/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal.convert;

import com.teamdev.jxbrowser.frame.internal.convert.AbstractValue;
import com.teamdev.jxbrowser.frame.internal.convert.BigIntValue;
import com.teamdev.jxbrowser.frame.internal.convert.JavaValue;
import com.teamdev.jxbrowser.frame.internal.convert.PrimitiveNumberValue;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import com.teamdev.jxbrowser.js.internal.rpc.NumberValue;

abstract class NumberValue
extends AbstractValue
implements JavaValue {
    NumberValue(JsValue jsValue) {
        super(jsValue);
    }

    public static NumberValue newInstance(JsValue jsValue) {
        Preconditions.checkNotNull(jsValue);
        Preconditions.checkArgument(jsValue.getValueCase() == JsValue.ValueCase.NUMBER_VALUE);
        NumberValue.ValueCase valueCase = jsValue.getNumberValue().getValueCase();
        return switch (valueCase) {
            case NumberValue.ValueCase.PRIMITIVE_VALUE -> new PrimitiveNumberValue(jsValue);
            case NumberValue.ValueCase.BIG_INT_VALUE -> new BigIntValue(jsValue);
            default -> throw new IllegalStateException("Unsupported number: " + String.valueOf(valueCase));
        };
    }
}

