/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal.convert;

import com.teamdev.jxbrowser.frame.internal.convert.CollectionValue;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.js.JsSet;
import com.teamdev.jxbrowser.js.internal.JsSetImpl;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import java.util.List;
import java.util.Set;

final class SetValue
extends CollectionValue {
    SetValue(JsValue jsValue) {
        super(jsValue);
        Preconditions.checkArgument(jsValue.getValueCase() == JsValue.ValueCase.SET);
    }

    @Override
    public List<Class<?>> destinationTypes() {
        return List.of(Set.class, JsSet.class);
    }

    @Override
    public <T> T toObject(Class<?> type) {
        Preconditions.checkNotNull(type);
        Preconditions.checkArgument(this.isConvertibleTo(type), "Cannot convert the value to: %s", type);
        JsSetImpl set = this.getOrCreateJsObject(this.jsValue().getSet().getId(), JsSetImpl.class);
        if (type.isAssignableFrom(Set.class)) {
            return (T)set.toSet();
        }
        return (T)set;
    }
}

