/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.internal.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

final class ChromiumSwitch {
    private final String name;
    private final String value;

    public static ChromiumSwitch of(String fullSwitch) {
        Preconditions.checkNotNull(fullSwitch);
        Preconditions.checkArgument(fullSwitch.startsWith("--"));
        String switchBody = fullSwitch.substring(2);
        int separatorIndex = switchBody.indexOf(61);
        if (separatorIndex < 0) {
            return new ChromiumSwitch(switchBody);
        }
        String name = switchBody.substring(0, separatorIndex);
        String value = switchBody.substring(separatorIndex + 1);
        return new ChromiumSwitch(name, value);
    }

    ChromiumSwitch(String name) {
        this.name = name;
        this.value = null;
    }

    ChromiumSwitch(String name, Object value) {
        this.name = name;
        this.value = value.toString();
    }

    public String name() {
        return this.name;
    }

    public Optional<String> value() {
        return Optional.ofNullable(this.value);
    }

    public List<String> values() {
        return Stream.ofNullable(this.value).flatMap(v -> Stream.of(v.split(","))).map(String::trim).filter(s -> !s.isEmpty()).toList();
    }

    public String toString() {
        return this.value == null ? String.format("--%s", this.name) : String.format("--%s=%s", this.name, this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChromiumSwitch)) {
            return false;
        }
        ChromiumSwitch that = (ChromiumSwitch)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }
}

