/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import javax.annotation.Nullable;

public final class Preconditions {
    private Preconditions() {
    }

    public static <T> T checkNotNull(@Nullable T object) {
        return Preconditions.checkNotNull(object, "", new Object[0]);
    }

    public static <T> T checkNotNull(@Nullable T object, String errorMessage, Object ... errorMessageParams) {
        if (object == null) {
            throw new NullPointerException(String.format(errorMessage, errorMessageParams));
        }
        return object;
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, String errorMessage, Object ... errorMessageParams) {
        if (!expression) {
            throw new IllegalStateException(String.format(errorMessage, errorMessageParams));
        }
    }

    public static void checkArgument(boolean expression) {
        Preconditions.checkArgument(expression, "", new Object[0]);
    }

    public static void checkArgument(boolean expression, String errorMessage, Object ... errorMessageParams) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(errorMessage, errorMessageParams));
        }
    }
}

