/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.platform.win;

import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.os.Environment;

public final class MessageLoopHelper {
    private static final ThreadLocal<Boolean> messageLoopThread = new ThreadLocal();

    public static void markAsMessageLoopThread() {
        Preconditions.checkState(Environment.isWindows());
        messageLoopThread.set(true);
    }

    public static boolean isSupported() {
        return !SystemProperties.hasProperty("jxbrowser.nested.ui.message.loop.disabled") && Environment.isWindows();
    }

    public static boolean isMessageLoopThread() {
        return Boolean.TRUE.equals(messageLoopThread.get());
    }

    public static void runNestedMessageLoop() {
        Preconditions.checkState(Environment.isWindows());
        ToolkitLibrary.instance().runNestedMessageLoop();
    }

    private MessageLoopHelper() {
    }
}

