/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.reflect;

import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.reflect.AccessibleObjects;
import com.teamdev.jxbrowser.internal.reflect.Classes;
import com.teamdev.jxbrowser.internal.reflect.ReflectionException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public final class Fields {
    public static Field declaredField(Class<?> cls, String name) {
        try {
            return cls.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionException(e);
        }
    }

    public static Field declaredField(String className, String name) {
        return Fields.declaredField(Classes.forName(className), name);
    }

    public static Set<Field> findFields(Class<?> cls, Predicate<Field> predicate) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (Field field : cls.getDeclaredFields()) {
            if (!predicate.test(field)) continue;
            fields.put(field.getName(), field);
        }
        if (cls.getSuperclass() != null) {
            Set<Field> superFields = Fields.findFields(cls.getSuperclass(), predicate);
            for (Field superField : superFields) {
                String superFieldName = superField.getName();
                if (fields.containsKey(superFieldName)) continue;
                fields.put(superFieldName, superField);
            }
        }
        return Set.copyOf(fields.values());
    }

    public static Optional<Field> findField(Class<?> cls, String name) {
        return Fields.findFields(cls, field -> field.getName().equals(name)).stream().findFirst();
    }

    public static <T> T value(Object instance, Field field) {
        Preconditions.checkNotNull(instance);
        Preconditions.checkNotNull(field);
        try {
            AccessibleObjects.makeAccessible(field);
            Object result = field.get(instance);
            return (T)result;
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }

    public static long longValue(Object instance, Field field) {
        Preconditions.checkNotNull(instance);
        Preconditions.checkNotNull(field);
        try {
            AccessibleObjects.makeAccessible(field);
            return field.getLong(instance);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }

    public static void setInaccessible(Field field, Object instance, Object value) {
        Preconditions.checkNotNull(field);
        Preconditions.checkNotNull(instance);
        try {
            AccessibleObjects.makeAccessible(field);
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }

    private Fields() {
    }
}

