/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.xz;

import com.teamdev.jxbrowser.VersionInfo;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.List;
import java.util.Optional;

public interface ResourceLocator {
    public static List<ResourceLocator> allLocators() {
        return List.of(ResourceLocator.legacyLocator(), ResourceLocator.moduleLocator());
    }

    public static Optional<URL> findResource(String resourceName) {
        List<ResourceLocator> locators = ResourceLocator.allLocators();
        for (ResourceLocator locator : locators) {
            Optional<URL> resource = locator.find(resourceName);
            if (!resource.isPresent()) continue;
            return resource;
        }
        return Optional.empty();
    }

    public static URL loadResource(String resourceName) throws FileNotFoundException {
        return ResourceLocator.findResource(resourceName).orElseThrow(() -> new FileNotFoundException("The resource " + resourceName + " is not found."));
    }

    public static ResourceLocator legacyLocator() {
        return resourceName -> {
            String resourcePath = "/" + VersionInfo.version() + "/" + resourceName;
            return Optional.ofNullable(ResourceLocator.class.getResource(resourcePath));
        };
    }

    public static ResourceLocator moduleLocator() {
        return resourceName -> {
            String resourcePath = VersionInfo.version() + "/" + resourceName;
            return Optional.ofNullable(ClassLoader.getSystemResource(resourcePath));
        };
    }

    public Optional<URL> find(String var1);
}

