/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.js;

import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.js.NotSupportedTypeException;
import com.teamdev.jxbrowser.js.TypeNotPublicException;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;

public final class JsAccessibleTypes {
    private static final Set<Class<?>> accessibleTypes = new HashSet();

    public static synchronized void makeAccessible(Class<?> ... publicTypes) {
        Preconditions.checkNotNull(publicTypes);
        for (Class<?> cls : publicTypes) {
            JsAccessibleTypes.openAccess(cls);
        }
    }

    public static synchronized void makeInaccessible(Class<?> ... publicTypes) {
        Preconditions.checkNotNull(publicTypes);
        for (Class<?> cls : publicTypes) {
            JsAccessibleTypes.closeAccess(cls);
        }
    }

    public static synchronized boolean isAccessible(Class<?> type) {
        Preconditions.checkNotNull(type);
        return accessibleTypes.contains(type);
    }

    private JsAccessibleTypes() {
    }

    private static void openAccess(Class<?> type) {
        Preconditions.checkNotNull(type);
        JsAccessibleTypes.checkType(type);
        JsAccessibleTypes.checkPublicity(type);
        accessibleTypes.add(type);
    }

    private static void closeAccess(Class<?> type) {
        Preconditions.checkNotNull(type);
        if (JsAccessibleTypes.isAccessible(type)) {
            accessibleTypes.remove(type);
        }
    }

    private static void checkType(Class<?> type) {
        if (type.isAnnotation()) {
            throw JsAccessibleTypes.notSupportedType("%s is an annotation. %s", type);
        }
        if (type.isEnum()) {
            throw JsAccessibleTypes.notSupportedType("%s is an enum. %s", type);
        }
    }

    private static NotSupportedTypeException notSupportedType(String fmt, Class<?> cls) {
        String warningMessage = "Access can be opened only for public classes and interfaces (not enums or annotations).";
        String msg = String.format(fmt, cls.getCanonicalName(), warningMessage);
        return new NotSupportedTypeException(msg);
    }

    private static void checkPublicity(Class<?> type) {
        if (!Modifier.isPublic(type.getModifiers())) {
            String msg = String.format("%s is not public. Access can be opened only for methods of public classes.", type.getCanonicalName());
            throw new TypeNotPublicException(msg);
        }
    }
}

