/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.js.internal;

import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.JsObjectProxyId;
import com.teamdev.jxbrowser.js.internal.JsAccessibleObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

final class JsAccessibleObjects
extends CloseableImpl {
    private final Map<JsObjectProxyId, JsAccessibleObject> proxies = new HashMap<JsObjectProxyId, JsAccessibleObject>();
    private final Map<Integer, JsObjectProxyId> proxyIdentifiers = new HashMap<Integer, JsObjectProxyId>();

    JsAccessibleObjects() {
    }

    public void add(JsObjectProxyId id, Object object) {
        Preconditions.checkNotNull(id);
        Preconditions.checkNotNull(object);
        int hashCode = JsAccessibleObjects.hash(object);
        this.proxies.put(id, new JsAccessibleObject(object));
        this.proxyIdentifiers.put(hashCode, id);
    }

    @Override
    public void close() {
        this.proxies.clear();
        this.proxyIdentifiers.clear();
        super.close();
    }

    public Optional<JsObjectProxyId> getId(Object object) {
        Preconditions.checkNotNull(object);
        return Optional.ofNullable(this.proxyIdentifiers.get(JsAccessibleObjects.hash(object)));
    }

    Optional<JsAccessibleObject> getJavaObject(JsObjectProxyId id) {
        return Optional.ofNullable(this.proxies.get(id));
    }

    private static int hash(Object object) {
        return System.identityHashCode(object);
    }
}

