/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.browser.internal.rpc.UserAgentBrandVersion;
import com.teamdev.jxbrowser.browser.internal.rpc.UserAgentMetadata;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import com.teamdev.jxbrowser.net.UserAgentBrand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public interface UserAgentData {
    public static Builder newBuilder() {
        return new Builder();
    }

    @Immutable
    default public List<UserAgentBrand> brands() {
        ArrayList<UserAgentBrandVersion> result = new ArrayList<UserAgentBrandVersion>();
        result.addAll(((UserAgentMetadata)this).getBrandVersionListList());
        result.addAll(((UserAgentMetadata)this).getBrandFullVersionListList());
        return Collections.unmodifiableList(result);
    }

    @Immutable
    default public List<String> formFactors() {
        return Collections.unmodifiableList(((UserAgentMetadata)this).getFormFactorsList());
    }

    default public String fullVersion() {
        return ((UserAgentMetadata)this).getFullVersion();
    }

    default public String platform() {
        return ((UserAgentMetadata)this).getPlatform();
    }

    default public String platformVersion() {
        return ((UserAgentMetadata)this).getPlatformVersion();
    }

    default public String architecture() {
        return ((UserAgentMetadata)this).getArchitecture();
    }

    default public String bitness() {
        return ((UserAgentMetadata)this).getBitness();
    }

    default public String model() {
        return ((UserAgentMetadata)this).getModel();
    }

    default public boolean isMobile() {
        return ((UserAgentMetadata)this).getMobile();
    }

    default public boolean isWow64() {
        return ((UserAgentMetadata)this).getWow64();
    }

    public static final class Builder {
        private final UserAgentMetadata.Builder builder = UserAgentMetadata.newBuilder();

        private Builder() {
        }

        public Builder addBrand(UserAgentBrand brand) {
            Preconditions.checkNotNull(brand);
            if (brand.version().contains(".")) {
                this.builder.addBrandFullVersionList(UserAgentBrandVersion.cast(brand));
            } else {
                this.builder.addBrandVersionList(UserAgentBrandVersion.cast(brand));
            }
            return this;
        }

        public Builder addFormFactor(String formFactor) {
            StringPreconditions.checkNotNullEmptyOrBlank(formFactor);
            this.builder.addFormFactors(formFactor);
            return this;
        }

        public Builder fullVersion(String fullVersion) {
            StringPreconditions.checkNotNullEmptyOrBlank(fullVersion);
            this.builder.setFullVersion(fullVersion);
            return this;
        }

        public Builder platform(String platform) {
            StringPreconditions.checkNotNullEmptyOrBlank(platform);
            this.builder.setPlatform(platform);
            return this;
        }

        public Builder platformVersion(String platformVersion) {
            StringPreconditions.checkNotNullEmptyOrBlank(platformVersion);
            this.builder.setPlatformVersion(platformVersion);
            return this;
        }

        public Builder architecture(String architecture) {
            StringPreconditions.checkNotNullEmptyOrBlank(architecture);
            this.builder.setArchitecture(architecture);
            return this;
        }

        public Builder bitness(String bitness) {
            StringPreconditions.checkNotNullEmptyOrBlank(bitness);
            this.builder.setBitness(bitness);
            return this;
        }

        public Builder model(String model) {
            StringPreconditions.checkNotNullEmptyOrBlank(model);
            this.builder.setModel(model);
            return this;
        }

        public Builder mobile(boolean mobile) {
            this.builder.setMobile(mobile);
            return this;
        }

        public Builder wow64(boolean wow64) {
            this.builder.setWow64(wow64);
            return this;
        }

        public UserAgentData build() {
            return this.builder.build();
        }
    }
}

