/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net.callback;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.net.HttpHeader;
import com.teamdev.jxbrowser.net.MimeType;
import com.teamdev.jxbrowser.net.UrlRequest;
import com.teamdev.jxbrowser.net.callback.NetworkSyncCallback;
import com.teamdev.jxbrowser.net.internal.rpc.HttpHeaderList;
import com.teamdev.jxbrowser.net.internal.rpc.ReceiveHeaders;
import java.util.Collections;
import java.util.List;

public interface ReceiveHeadersCallback
extends NetworkSyncCallback<Params, Response> {

    public static interface Response {
        public static Response override(List<HttpHeader> httpHeaders) {
            Preconditions.checkNotNull(httpHeaders);
            HttpHeaderList.Builder builder = HttpHeaderList.newBuilder();
            httpHeaders.forEach(httpHeader -> builder.addHttpHeader((com.teamdev.jxbrowser.net.internal.rpc.HttpHeader)httpHeader));
            return ReceiveHeaders.Response.newBuilder().setOverrideWith(builder.build()).build();
        }

        public static Response proceed() {
            return ReceiveHeaders.Response.newBuilder().setContinue(Protobuf.empty()).build();
        }
    }

    public static interface Params {
        default public UrlRequest urlRequest() {
            return ((ReceiveHeaders.Request)this).getUrlRequest();
        }

        @Immutable
        default public List<HttpHeader> httpHeaders() {
            return Collections.unmodifiableList(((ReceiveHeaders.Request)this).getHttpHeaderList());
        }

        default public long contentLength() {
            return ((ReceiveHeaders.Request)this).getContentLength();
        }

        default public String charset() {
            return ((ReceiveHeaders.Request)this).getCharset();
        }

        default public String ipAddress() {
            return ((ReceiveHeaders.Request)this).getIpAddress();
        }

        default public MimeType mimeType() {
            return ((ReceiveHeaders.Request)this).getMimeType();
        }

        default public String statusLine() {
            return ((ReceiveHeaders.Request)this).getStatusLine().value();
        }

        default public String statusText() {
            return ((ReceiveHeaders.Request)this).getStatusText().value();
        }

        default public int responseCode() {
            return ((ReceiveHeaders.Request)this).getResponseCode();
        }
    }
}

