/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net.callback;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.net.Host;
import com.teamdev.jxbrowser.net.callback.NetworkSyncCallback;
import com.teamdev.jxbrowser.net.internal.rpc.CertVerificationStatusList;
import com.teamdev.jxbrowser.net.internal.rpc.VerifyCertificate;
import com.teamdev.jxbrowser.net.tls.CertVerificationError;
import com.teamdev.jxbrowser.net.tls.CertVerificationStatus;
import com.teamdev.jxbrowser.net.tls.Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public interface VerifyCertificateCallback
extends NetworkSyncCallback<Params, Response> {

    public static interface Response {
        public static Response valid() {
            return VerifyCertificate.Response.newBuilder().setValid(Protobuf.empty()).build();
        }

        public static Response invalid(CertVerificationStatus ... verificationStatuses) {
            Preconditions.checkNotNull(verificationStatuses);
            List<com.teamdev.jxbrowser.net.tls.internal.rpc.CertVerificationStatus> statuses = Arrays.stream(verificationStatuses).map(com.teamdev.jxbrowser.net.tls.internal.rpc.CertVerificationStatus::fromPublic).toList();
            CertVerificationStatusList statusList = CertVerificationStatusList.newBuilder().addAllVerificationStatus(statuses).build();
            return VerifyCertificate.Response.newBuilder().setInvalid(statusList).build();
        }

        public static Response defaultAction() {
            return VerifyCertificate.Response.newBuilder().setDefault(Protobuf.empty()).build();
        }
    }

    public static interface Params {
        default public Host host() {
            return ((VerifyCertificate.Request)this).getHost();
        }

        default public Certificate certificate() {
            return ((VerifyCertificate.Request)this).getCertificate();
        }

        @Immutable
        default public List<Certificate> intermediateCertificates() {
            return ((VerifyCertificate.Request)this).getIntermediateCertificatesList().stream().map(certificate -> certificate).collect(Collectors.toList());
        }

        @Immutable
        default public List<CertVerificationError> verificationErrors() {
            return List.copyOf(((VerifyCertificate.Request)this).getVerificationErrorList());
        }

        @Deprecated(since="7.26", forRemoval=true)
        @Immutable
        default public List<CertVerificationStatus> verificationStatuses() {
            return this.verificationErrors().stream().map(CertVerificationError::status).toList();
        }
    }
}

