/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net.internal;

import com.teamdev.jxbrowser.internal.Wrappers;
import com.teamdev.jxbrowser.net.HttpHeader;
import com.teamdev.jxbrowser.net.Scheme;
import com.teamdev.jxbrowser.net.UploadData;
import com.teamdev.jxbrowser.net.UrlRequest;
import com.teamdev.jxbrowser.net.UrlRequestJob;
import com.teamdev.jxbrowser.net.callback.InterceptUrlRequestCallback;
import com.teamdev.jxbrowser.net.internal.NetworkImpl;
import com.teamdev.jxbrowser.net.internal.callback.InterceptRequestCallback;
import com.teamdev.jxbrowser.net.internal.rpc.InterceptRequest;
import com.teamdev.jxbrowser.net.internal.rpc.UploadData;
import com.teamdev.jxbrowser.net.internal.rpc.UrlRequestJobOptions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

final class InterceptRequestCallbackProxy
implements InterceptRequestCallback {
    private final NetworkImpl network;
    private final Map<Scheme, InterceptUrlRequestCallback> schemes;

    InterceptRequestCallbackProxy(NetworkImpl network, Map<Scheme, InterceptUrlRequestCallback> schemes) {
        this.network = network;
        this.schemes = Map.copyOf(schemes);
    }

    @Override
    public InterceptRequest.Response on(InterceptRequest.Request request) {
        String url = request.getUrlRequest().url();
        for (Scheme scheme : this.schemes.keySet()) {
            if (!url.startsWith(scheme.name() + ":")) continue;
            InterceptUrlRequestCallback callback = this.schemes.get(scheme);
            return (InterceptRequest.Response)callback.on(new InterceptUrlRequestParams(this.network, request));
        }
        throw new IllegalStateException("Unsupported URL scheme: " + url);
    }

    private static final class InterceptUrlRequestParams
    implements InterceptUrlRequestCallback.Params {
        private final NetworkImpl network;
        private final InterceptRequest.Request request;

        InterceptUrlRequestParams(NetworkImpl network, InterceptRequest.Request request) {
            this.network = network;
            this.request = request;
        }

        @Override
        public UrlRequest urlRequest() {
            return this.request.getUrlRequest();
        }

        @Override
        public Optional<UploadData> uploadData() {
            com.teamdev.jxbrowser.net.internal.rpc.UploadData uploadData = this.request.getUploadData();
            UploadData.DataCase dataCase = uploadData.getDataCase();
            if (dataCase.equals(UploadData.DataCase.BYTE_DATA)) {
                return Optional.of(uploadData.getByteData());
            }
            if (dataCase.equals(UploadData.DataCase.TEXT_DATA)) {
                return Optional.of(uploadData.getTextData());
            }
            if (dataCase.equals(UploadData.DataCase.FORM_DATA)) {
                return Optional.of(uploadData.getFormData());
            }
            if (dataCase.equals(UploadData.DataCase.MULTIPART_FORM_DATA)) {
                return Optional.of(uploadData.getMultipartFormData());
            }
            return Optional.empty();
        }

        @Override
        public List<HttpHeader> httpHeaders() {
            return Collections.unmodifiableList(this.request.getHttpHeaderList());
        }

        @Override
        public UrlRequestJob newUrlRequestJob(UrlRequestJob.Options options) {
            UrlRequestJobOptions rpcOptions = Wrappers.unwrap(options, UrlRequestJobOptions.class).toBuilder().setUrlRequestId(this.request.getUrlRequest().getId()).build();
            return this.network.newUrlRequestJob(rpcOptions);
        }
    }
}

