/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.print.internal;

import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.PrintJobId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.print.Capabilities;
import com.teamdev.jxbrowser.print.PrintJob;
import com.teamdev.jxbrowser.print.event.PrintCompleted;
import com.teamdev.jxbrowser.print.event.PrintJobEvent;
import com.teamdev.jxbrowser.print.internal.rpc.PrintJobStub;
import com.teamdev.jxbrowser.print.internal.rpc.PrintSettings;
import com.teamdev.jxbrowser.print.internal.settings.PrintSettingsConstructor;

public final class PrintJobImpl<PrintSettingsT extends com.teamdev.jxbrowser.print.PrintSettings>
extends CloseableImpl
implements PrintJob<PrintSettingsT> {
    private final PrintJobId id;
    private final PrintSettingsT settings;
    private final ServiceConnection<PrintJobStub> rpc;

    public PrintJobImpl(BrowserImpl browser, PrintJobId printJobId, PrintSettingsConstructor<PrintSettingsT> ctor) {
        Connection connection = browser.engine().connection();
        this.rpc = new ServiceConnectionImpl<PrintJobStub>(printJobId, connection, PrintJobStub::new);
        this.id = printJobId;
        this.settings = (com.teamdev.jxbrowser.print.PrintSettings)ctor.newInstance(this.capabilities(), printJobId, this.rpc, this.currentSettings());
        this.on(PrintCompleted.class, event -> this.close());
    }

    Capabilities capabilities() {
        return (Capabilities)this.rpc.invoke(this.rpc.stub()::getPrinterCapabilities, this.id);
    }

    private PrintSettings currentSettings() {
        return (PrintSettings)this.rpc.invoke(this.rpc.stub()::getSettings, this.id);
    }

    public PrintJobId id() {
        return this.id;
    }

    @Override
    public PrintSettingsT settings() {
        return this.settings;
    }

    @Override
    public <E extends PrintJobEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }

    @Override
    public void close() {
        this.rpc.close();
        ((CloseableImpl)this.settings).close();
        super.close();
    }
}

