/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.time;

import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.time.Timestamp;

public final class TimeRange {
    public static final TimeRange FULL = TimeRange.between(Timestamp.NONE, Timestamp.MAX);
    private final Timestamp start;
    private final Timestamp end;

    private TimeRange() {
        this.start = Timestamp.NONE;
        this.end = Timestamp.NONE;
    }

    private TimeRange(Timestamp from, Timestamp to) {
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        this.start = from;
        this.end = to;
    }

    public static TimeRange between(Timestamp start, Timestamp end) {
        Preconditions.checkNotNull(start);
        Preconditions.checkNotNull(end);
        Preconditions.checkArgument(start.toInstant().isBefore(end.toInstant()));
        return new TimeRange(start, end);
    }

    public static TimeRange startingFrom(Timestamp start) {
        Preconditions.checkNotNull(start);
        return TimeRange.between(start, Timestamp.MAX);
    }

    public static TimeRange upTo(Timestamp end) {
        Preconditions.checkNotNull(end);
        return TimeRange.between(Timestamp.NONE, end);
    }

    public Timestamp start() {
        return this.start;
    }

    public Timestamp end() {
        return this.end;
    }
}

