/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.ui;

import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.ui.internal.rpc.Color;

public interface Color {
    public static Builder newBuilder() {
        return new Builder();
    }

    public static Color rgba(float red, float green, float blue, float alpha) {
        return Color.newBuilder().red(red).green(green).blue(blue).alpha(alpha).build();
    }

    public static Color rgb(float red, float green, float blue) {
        return Color.rgba(red, green, blue, 1.0f);
    }

    default public boolean isValid() {
        float red = this.red();
        if (red < 0.0f || red > 1.0f) {
            return false;
        }
        float green = this.green();
        if (green < 0.0f || green > 1.0f) {
            return false;
        }
        float blue = this.blue();
        if (blue < 0.0f || blue > 1.0f) {
            return false;
        }
        float alpha = this.alpha();
        return alpha >= 0.0f && alpha <= 1.0f;
    }

    default public String toHexRGBA() {
        Preconditions.checkArgument(this.isValid());
        int r = (int)Math.round((double)this.red() * 255.0);
        int g = (int)Math.round((double)this.green() * 255.0);
        int b = (int)Math.round((double)this.blue() * 255.0);
        int a = (int)Math.round((double)this.alpha() * 255.0);
        return String.format("#%02x%02x%02x%02x", r, g, b, a);
    }

    default public String toHexRGB() {
        Preconditions.checkArgument(this.isValid());
        int r = (int)Math.round((double)this.red() * 255.0);
        int g = (int)Math.round((double)this.green() * 255.0);
        int b = (int)Math.round((double)this.blue() * 255.0);
        return String.format("#%02x%02x%02x", r, g, b);
    }

    default public float alpha() {
        return ((com.teamdev.jxbrowser.ui.internal.rpc.Color)this).getAlpha();
    }

    default public float blue() {
        return ((com.teamdev.jxbrowser.ui.internal.rpc.Color)this).getBlue();
    }

    default public float green() {
        return ((com.teamdev.jxbrowser.ui.internal.rpc.Color)this).getGreen();
    }

    default public float red() {
        return ((com.teamdev.jxbrowser.ui.internal.rpc.Color)this).getRed();
    }

    public static final class Builder {
        private final Color.Builder builder = com.teamdev.jxbrowser.ui.internal.rpc.Color.newBuilder();

        private Builder() {
        }

        public Builder red(float red) {
            Preconditions.checkArgument(red >= 0.0f && red <= 1.0f);
            this.builder.setRed(red);
            return this;
        }

        public Builder green(float green) {
            Preconditions.checkArgument(green >= 0.0f && green <= 1.0f);
            this.builder.setGreen(green);
            return this;
        }

        public Builder blue(float blue) {
            Preconditions.checkArgument(blue >= 0.0f && blue <= 1.0f);
            this.builder.setBlue(blue);
            return this;
        }

        public Builder alpha(float alpha) {
            Preconditions.checkArgument(alpha >= 0.0f && alpha <= 1.0f);
            this.builder.setAlpha(alpha);
            return this;
        }

        public Color build() {
            return this.builder.build();
        }
    }
}

