/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.ui.event;

import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.ui.KeyModifiers;
import com.teamdev.jxbrowser.ui.MouseButton;
import com.teamdev.jxbrowser.ui.MouseModifiers;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.event.MouseEvent;
import com.teamdev.jxbrowser.ui.event.MouseEvents;
import com.teamdev.jxbrowser.ui.event.internal.rpc.MouseEntered;

public interface MouseEntered
extends MouseEvent {
    public static Builder newBuilder(Point location) {
        Preconditions.checkNotNull(location);
        return new Builder(location);
    }

    @Override
    default public Point location() {
        return MouseEvents.cast(this).getLocation();
    }

    @Override
    default public Point locationOnScreen() {
        return MouseEvents.cast(this).getLocationOnScreen();
    }

    public static final class Builder {
        private final MouseEntered.Builder builder;

        private Builder(Point location) {
            this.builder = com.teamdev.jxbrowser.ui.event.internal.rpc.MouseEntered.newBuilder().setLocation((com.teamdev.jxbrowser.ui.internal.rpc.Point)location);
        }

        public Builder locationOnScreen(Point locationOnScreen) {
            Preconditions.checkNotNull(locationOnScreen);
            this.builder.setLocationOnScreen((com.teamdev.jxbrowser.ui.internal.rpc.Point)locationOnScreen);
            return this;
        }

        public Builder button(MouseButton mouseButton) {
            Preconditions.checkNotNull(mouseButton);
            this.builder.setButton(com.teamdev.jxbrowser.ui.internal.rpc.MouseButton.fromPublic(mouseButton));
            return this;
        }

        public Builder keyModifiers(KeyModifiers keyModifiers) {
            Preconditions.checkNotNull(keyModifiers);
            this.builder.setKeyModifiers((com.teamdev.jxbrowser.ui.event.internal.rpc.KeyModifiers)keyModifiers);
            return this;
        }

        public Builder mouseModifiers(MouseModifiers mouseModifiers) {
            Preconditions.checkNotNull(mouseModifiers);
            this.builder.setMouseModifiers((com.teamdev.jxbrowser.ui.event.internal.rpc.MouseModifiers)mouseModifiers);
            return this;
        }

        public MouseEntered build() {
            return this.builder.build();
        }
    }
}

