/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.ui.event;

import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.ui.KeyModifiers;
import com.teamdev.jxbrowser.ui.event.TouchEvent;
import com.teamdev.jxbrowser.ui.event.internal.rpc.TouchEnded;
import com.teamdev.jxbrowser.ui.event.internal.rpc.TouchPoint;
import java.util.List;

public interface TouchEnded
extends TouchEvent {
    public static Builder newBuilder(List<com.teamdev.jxbrowser.ui.TouchPoint> touches) {
        Preconditions.checkNotNull(touches);
        Preconditions.checkArgument(!touches.isEmpty());
        return new Builder(touches);
    }

    @Override
    default public List<com.teamdev.jxbrowser.ui.TouchPoint> touches() {
        return com.teamdev.jxbrowser.ui.event.internal.rpc.TouchEnded.cast(this).getPointsList().stream().map(point -> point).toList();
    }

    @Override
    default public List<com.teamdev.jxbrowser.ui.TouchPoint> targetTouches() {
        return com.teamdev.jxbrowser.ui.event.internal.rpc.TouchEnded.cast(this).getTargetTouchesList().stream().map(point -> point).toList();
    }

    @Override
    default public List<com.teamdev.jxbrowser.ui.TouchPoint> changedTouches() {
        return com.teamdev.jxbrowser.ui.event.internal.rpc.TouchEnded.cast(this).getChangedTouchesList().stream().map(point -> point).toList();
    }

    default public KeyModifiers keyModifiers() {
        return com.teamdev.jxbrowser.ui.event.internal.rpc.TouchEnded.cast(this).getKeyModifiers();
    }

    public static final class Builder {
        private final TouchEnded.Builder builder;

        private Builder(List<com.teamdev.jxbrowser.ui.TouchPoint> touches) {
            Preconditions.checkNotNull(touches);
            this.builder = com.teamdev.jxbrowser.ui.event.internal.rpc.TouchEnded.newBuilder().addAllPoints(Builder.convertToRpc(touches));
        }

        public Builder changedTouches(List<com.teamdev.jxbrowser.ui.TouchPoint> points) {
            Preconditions.checkNotNull(points);
            this.builder.addAllChangedTouches(Builder.convertToRpc(points));
            return this;
        }

        public Builder targetTouches(List<com.teamdev.jxbrowser.ui.TouchPoint> points) {
            Preconditions.checkNotNull(points);
            this.builder.addAllTargetTouches(Builder.convertToRpc(points));
            return this;
        }

        public Builder keyModifiers(KeyModifiers keyModifiers) {
            Preconditions.checkNotNull(keyModifiers);
            this.builder.setKeyModifiers(com.teamdev.jxbrowser.ui.event.internal.rpc.KeyModifiers.cast(keyModifiers));
            return this;
        }

        public TouchEnded build() {
            return this.builder.build();
        }

        private static List<TouchPoint> convertToRpc(List<com.teamdev.jxbrowser.ui.TouchPoint> points) {
            return points.stream().map(TouchPoint::cast).toList();
        }
    }
}

