/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.ui.internal;

import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.ui.KeyCode;
import com.teamdev.jxbrowser.ui.KeyModifiers;
import com.teamdev.jxbrowser.ui.event.KeyPressed;
import com.teamdev.jxbrowser.ui.internal.KeyCodes;
import java.util.Set;

public final class KeyEvents {
    private KeyEvents() {
    }

    static KeyPressed keyStroke(KeyCode keyCode, Set<KeyModifiers> modifiers) {
        Preconditions.checkNotNull(keyCode);
        Preconditions.checkNotNull(modifiers);
        KeyModifiers.Builder builder = KeyModifiers.newBuilder();
        for (KeyModifiers modifier : modifiers) {
            if (modifier.isMetaDown()) {
                builder.metaDown(true);
            }
            if (modifier.isControlDown()) {
                builder.controlDown(true);
            }
            if (modifier.isAltDown()) {
                builder.altDown(true);
            }
            if (modifier.isAltGraphDown()) {
                builder.altGraphDown(true);
            }
            if (!modifier.isShiftDown()) continue;
            builder.shiftDown(true);
        }
        return KeyPressed.newBuilder(keyCode).keyModifiers(builder.build()).build();
    }

    public static boolean isMacAccessKey(KeyCode keyCode, KeyModifiers modifiers) {
        return KeyCodes.isAlphabetic(keyCode) && modifiers.isControlDown() && modifiers.isAltDown();
    }

    static KeyPressed onlyCodeAndModifiers(KeyPressed event) {
        Preconditions.checkNotNull(event);
        return KeyPressed.newBuilder(event.keyCode()).keyModifiers(event.keyModifiers()).build();
    }
}

