/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.ui.internal;

import com.teamdev.jxbrowser.frame.EditorCommand;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.ui.KeyCode;
import com.teamdev.jxbrowser.ui.KeyModifiers;
import com.teamdev.jxbrowser.ui.event.KeyPressed;
import com.teamdev.jxbrowser.ui.internal.CommandMapping;
import java.util.Optional;

public final class MacEditorCommand {
    private static final CommandMapping mapping = CommandMapping.newBuilder().withMetaDown(EditorCommand.copy(), KeyCode.KEY_CODE_C).withMetaDown(EditorCommand.cut(), KeyCode.KEY_CODE_X).withMetaDown(EditorCommand.paste(), KeyCode.KEY_CODE_V).withMetaDown(EditorCommand.selectAll(), KeyCode.KEY_CODE_A).withMetaDown(EditorCommand.undo(), KeyCode.KEY_CODE_Z).withMetaAndShiftDown(EditorCommand.redo(), KeyCode.KEY_CODE_Z).withMetaDown(EditorCommand.deleteToBeginningOfLine(), KeyCode.KEY_CODE_BACK).withMetaDown(EditorCommand.moveToBeginningOfLine(), KeyCode.KEY_CODE_LEFT).withMetaAndShiftDown(EditorCommand.moveToBeginningOfLineAndModifySelection(), KeyCode.KEY_CODE_LEFT).withMetaDown(EditorCommand.moveToEndOfLine(), KeyCode.KEY_CODE_RIGHT).withMetaAndShiftDown(EditorCommand.moveToEndOfLineAndModifySelection(), KeyCode.KEY_CODE_RIGHT).build();

    public static Optional<EditorCommand> of(KeyPressed event) {
        Preconditions.checkNotNull(event);
        return mapping.commandFor(event);
    }

    private MacEditorCommand() {
    }

    static KeyModifiers metaDown() {
        return KeyModifiers.newBuilder().metaDown(true).build();
    }

    static KeyModifiers shiftDown() {
        return KeyModifiers.newBuilder().shiftDown(true).build();
    }

    static KeyModifiers altDown() {
        return KeyModifiers.newBuilder().altDown(true).build();
    }
}

