/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.ui.internal;

import com.teamdev.jxbrowser.ui.internal.rpc.CursorType;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;

public final class ToolkitCursors<T> {
    private final Map<CursorType, T> cursors;

    public static <T> Builder<T> newBuilder() {
        return new Builder();
    }

    private ToolkitCursors(Builder<T> builder) {
        this.cursors = Map.copyOf(builder.cursors);
    }

    public Optional<T> get(CursorType type) {
        T cursor = this.cursors.get(type);
        return Optional.ofNullable(cursor);
    }

    public static class Builder<T> {
        private final Map<CursorType, T> cursors = new EnumMap<CursorType, T>(CursorType.class);

        private Builder() {
        }

        public Builder<T> add(CursorType cursorType, T cursor) {
            this.cursors.put(cursorType, cursor);
            return this;
        }

        public ToolkitCursors<T> build() {
            return new ToolkitCursors(this);
        }
    }
}

