/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.zoom;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.internal.Preconditions;
import java.util.List;
import java.util.Objects;

public final class ZoomLevel {
    public static final ZoomLevel P_25 = new ZoomLevel(0.25);
    public static final ZoomLevel P_33 = new ZoomLevel(0.3333333333333333);
    public static final ZoomLevel P_50 = new ZoomLevel(0.5);
    public static final ZoomLevel P_67 = new ZoomLevel(0.6666666666666666);
    public static final ZoomLevel P_75 = new ZoomLevel(0.75);
    public static final ZoomLevel P_80 = new ZoomLevel(0.8);
    public static final ZoomLevel P_90 = new ZoomLevel(0.9);
    public static final ZoomLevel P_100 = new ZoomLevel(1.0);
    public static final ZoomLevel P_110 = new ZoomLevel(1.1);
    public static final ZoomLevel P_125 = new ZoomLevel(1.25);
    public static final ZoomLevel P_150 = new ZoomLevel(1.5);
    public static final ZoomLevel P_175 = new ZoomLevel(1.75);
    public static final ZoomLevel P_200 = new ZoomLevel(2.0);
    public static final ZoomLevel P_250 = new ZoomLevel(2.5);
    public static final ZoomLevel P_300 = new ZoomLevel(3.0);
    public static final ZoomLevel P_400 = new ZoomLevel(4.0);
    public static final ZoomLevel P_500 = new ZoomLevel(5.0);
    private static final double EPSILON = 0.001;
    private static final List<ZoomLevel> VALUES = List.of(P_25, P_33, P_50, P_67, P_75, P_80, P_100, P_110, P_125, P_150, P_175, P_200, P_250, P_300, P_400, P_500);
    private final double value;

    public static ZoomLevel of(double value) {
        Preconditions.checkArgument(Double.compare(value, 0.0) >= 0);
        for (ZoomLevel level : VALUES) {
            if (!ZoomLevel.compareZoomFactor(level.value, value)) continue;
            return level;
        }
        return new ZoomLevel(value);
    }

    @Immutable
    public static List<ZoomLevel> values() {
        return VALUES;
    }

    private ZoomLevel(double value) {
        this.value = value;
    }

    public String toString() {
        return String.format("ZoomLevel [%.2f]", this.value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ZoomLevel)) {
            return false;
        }
        ZoomLevel level = (ZoomLevel)obj;
        return ZoomLevel.compareZoomFactor(this.value, level.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    private static boolean compareZoomFactor(double first, double second) {
        if (first == second) {
            return true;
        }
        return Math.abs(first - second) < 0.001;
    }

    public double value() {
        return this.value;
    }
}

