/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.zoom.internal;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.zoom.Zoom;
import com.teamdev.jxbrowser.zoom.ZoomLevel;
import com.teamdev.jxbrowser.zoom.internal.rpc.BrowserZoomLevel;
import com.teamdev.jxbrowser.zoom.internal.rpc.SetZoomEnabledRequest;
import com.teamdev.jxbrowser.zoom.internal.rpc.ZoomLevelValue;
import com.teamdev.jxbrowser.zoom.internal.rpc.ZoomStub;

public final class ZoomImpl
extends CloseableImpl
implements Zoom {
    private final BrowserImpl browser;
    private final ServiceConnectionImpl<ZoomStub> rpc;

    public ZoomImpl(BrowserImpl browser) {
        Preconditions.checkNotNull(browser);
        this.browser = browser;
        this.rpc = new ServiceConnectionImpl<ZoomStub>(browser.id(), browser.engine().connection(), ZoomStub::new);
    }

    @Override
    public Browser browser() {
        return this.browser;
    }

    @Override
    public ZoomLevel level() {
        this.checkNotClosed();
        return ZoomLevel.of(((ZoomLevelValue)this.rpc.invoke(this.rpc.stub()::getLevel, this.browser.id())).getZoomLevel());
    }

    @Override
    public void level(ZoomLevel zoomLevel) {
        Preconditions.checkNotNull(zoomLevel);
        this.checkNotClosed();
        BrowserZoomLevel request = BrowserZoomLevel.newBuilder().setBrowserId(this.browser.id()).setZoomValue(ZoomLevelValue.newBuilder().setZoomLevel(zoomLevel.value()).build()).build();
        this.rpc.invokeAsync(this.rpc.stub()::setLevel, request);
    }

    @Override
    public void in() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::in, this.browser.id());
    }

    @Override
    public void out() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::out, this.browser.id());
    }

    @Override
    public void reset() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::reset, this.browser.id());
    }

    @Override
    public boolean isEnabled() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::getEnabled, this.browser.id())).getValue();
    }

    private void setZoomEnabled(boolean enabled) {
        this.checkNotClosed();
        SetZoomEnabledRequest request = SetZoomEnabledRequest.newBuilder().setBrowserId(this.browser.id()).setZoomEnabled(enabled).build();
        this.rpc.invokeAsync(this.rpc.stub()::setEnabled, request);
    }

    @Override
    public void enable() {
        this.setZoomEnabled(true);
    }

    @Override
    public void disable() {
        this.setZoomEnabled(false);
    }
}

