/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.graphics;

import com.teamdev.jxbrowser.ui.Bitmap;
import com.teamdev.jxbrowser.ui.Size;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public final class BitmapImage
extends com.teamdev.jxbrowser.view.graphics.BitmapImage<BufferedImage> {
    private static final int PIXEL_STRIDE = 4;

    public static BufferedImage toToolkit(Bitmap bitmap) {
        return (BufferedImage)new BitmapImage(bitmap).toolkitImage();
    }

    private BitmapImage(Bitmap bitmap) {
        super(bitmap);
    }

    protected BufferedImage createImage() {
        Bitmap bitmap = this.bitmap();
        Size size = bitmap.size();
        int width = size.width();
        int height = size.height();
        WritableRaster raster = Raster.createInterleavedRaster(0, width, height, width * 4, 4, new int[]{2, 1, 0, 3}, null);
        ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, true, 3, 0);
        DataBufferByte dataBuffer = (DataBufferByte)raster.getDataBuffer();
        byte[] pixels = bitmap.pixels();
        System.arraycopy(pixels, 0, dataBuffer.getData(), 0, pixels.length);
        return new BufferedImage(colorModel, raster, true, null);
    }
}

