/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DragGestureListener;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DragImage;
import java.util.Optional;

public final class BrowserDragContext {
    private final DragGestureListener dragGestureListener = new DragGestureListener();
    private CurrentDragOperation dragOperation;
    private boolean swingDragStarted;
    private boolean externalDragEnabled = true;

    static BrowserDragContext newInstance() {
        return new BrowserDragContext();
    }

    private BrowserDragContext() {
    }

    public Optional<CurrentDragOperation> browserDragOperation() {
        return Optional.ofNullable(this.dragOperation);
    }

    void browserDragOperation(DropData dropData, DragImage dragImage) {
        Preconditions.checkNotNull((Object)dropData);
        Preconditions.checkNotNull((Object)dragImage);
        this.dragOperation = new CurrentDragOperation(dragImage, dropData);
    }

    public boolean isSwingDragHappening() {
        return this.swingDragStarted;
    }

    public boolean isBrowserDragHappening() {
        return this.dragOperation != null;
    }

    void resetBrowserDragOperation() {
        this.dragOperation = null;
        this.swingDragStarted = false;
    }

    DragGestureListener dragGestureListener() {
        return this.dragGestureListener;
    }

    void onSwingDragStarted() {
        this.swingDragStarted = true;
    }

    public void setEnabledExternalDrag(boolean enabled) {
        this.externalDragEnabled = enabled;
    }

    boolean isExternalDragEnabled() {
        return this.externalDragEnabled;
    }

    public static class CurrentDragOperation {
        private final DragImage dragImage;
        private final DropData dropData;

        private CurrentDragOperation(DragImage dragImage, DropData dropData) {
            this.dragImage = dragImage;
            this.dropData = dropData;
        }

        public DropData dropData() {
            return this.dropData;
        }

        DragImage dragImage() {
            return this.dragImage;
        }
    }
}

