/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.view.internal.CustomDataMimeType;
import com.teamdev.jxbrowser.view.swing.internal.dnd.CustomDataEnvelope;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.SystemFlavorMap;

final class CustomDataSupport {
    private static final CustomDataMimeType CUSTOM_FORMAT = CustomDataMimeType.forCurrentPlatform();
    static final DataFlavor RAW_CUSTOM_DATA = new DataFlavor(byte[].class, "Chromium Custom Drop Data");
    static final DataFlavor ENVELOPED_CUSTOM_DATA = new DataFlavor(CustomDataEnvelope.class, "Enveloped Chromium Custom Drop Data");

    private CustomDataSupport() {
    }

    static void configureFlavorMap() {
        SystemFlavorMap flavorMap = (SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap();
        flavorMap.setFlavorsForNative(CUSTOM_FORMAT.value(), new DataFlavor[]{RAW_CUSTOM_DATA});
        flavorMap.setNativesForFlavor(RAW_CUSTOM_DATA, new String[]{CUSTOM_FORMAT.value()});
    }

    static boolean isCustomDataFlavor(DataFlavor flavor) {
        String name = flavor.getHumanPresentableName();
        String rawDataName = RAW_CUSTOM_DATA.getHumanPresentableName();
        String envelopedDataName = ENVELOPED_CUSTOM_DATA.getHumanPresentableName();
        return rawDataName.equals(name) || envelopedDataName.equals(name);
    }
}

