/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DataType;
import com.teamdev.jxbrowser.view.swing.internal.dnd.FileListDataType;
import com.teamdev.jxbrowser.view.swing.internal.dnd.StringDataFlavor;
import java.awt.datatransfer.Transferable;
import java.nio.charset.StandardCharsets;
import java.util.List;

final class UrlDataType
extends DataType {
    private static final String CRLF = "\r\n";
    private static final String LF = "\n";
    private static final StringDataFlavor URI_LIST = StringDataFlavor.newInstance("text/uri-list");
    private static final StringDataFlavor JAVA_URL = StringDataFlavor.newInstance("application/x-java-url");
    private static final StringDataFlavor MOZ_URL = StringDataFlavor.newInstance("text/x-moz-url", StandardCharsets.UTF_16LE);

    UrlDataType() {
    }

    @Override
    public void fillDropData(Transferable transferable, DropData.Builder dropData) {
        if (Environment.isMac() && this.hasFiles(transferable)) {
            return;
        }
        this.supportedFlavors().stream().filter(flavor -> flavor.isPresentedIn(transferable)).findFirst().ifPresent(flavor -> {
            String url = this.extractUrl(flavor.read(transferable));
            dropData.setUrl(url);
        });
    }

    @Override
    public void fillMetadata(DropMetadata.Builder metadata) {
        metadata.setContainsUrl(true);
    }

    private String extractUrl(String rawString) {
        String separator = rawString.contains(CRLF) ? CRLF : LF;
        String[] chunks = rawString.split(separator);
        if (chunks.length != 0) {
            return chunks[0];
        }
        return "";
    }

    protected List<StringDataFlavor> supportedFlavors() {
        return List.of(URI_LIST, JAVA_URL, MOZ_URL);
    }

    private boolean hasFiles(Transferable transferable) {
        return FileListDataType.fileListFlavor.isPresentedIn(transferable);
    }
}

