/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.graphics;

import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.ui.Bitmap;
import com.teamdev.jxbrowser.ui.Size;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;

public final class BitmapImage
extends com.teamdev.jxbrowser.view.graphics.BitmapImage<Image> {
    private static final int SCANLINE_PAD = 1;
    private static final int DEPTH = 32;
    private final Device device;

    public static Image toToolkit(Device device, Bitmap bitmap) {
        return (Image)new BitmapImage(device, bitmap).toolkitImage();
    }

    private BitmapImage(Device device, Bitmap bitmap) {
        super(bitmap);
        this.device = (Device)Preconditions.checkNotNull((Object)device);
    }

    protected Image createImage() {
        Bitmap bitmap = this.bitmap();
        Size size = bitmap.size();
        int width = size.width();
        int height = size.height();
        PaletteData palette = new PaletteData(PaletteMask.RED.value, PaletteMask.GREEN.value, PaletteMask.BLUE.value);
        ImageData imageData = new ImageData(width, height, 32, palette, 1, bitmap.pixels());
        return new Image(this.device, imageData);
    }

    private static enum PaletteMask {
        RED(65280),
        GREEN(0xFF0000),
        BLUE(-16777216);

        private final int value;

        private PaletteMask(int value) {
            this.value = value;
        }
    }
}

