/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.rpc.FocusRequest;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.view.swt.BrowserView;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

final class TabbingAssistant {
    private final BrowserView browserView;

    TabbingAssistant(BrowserView browserView) {
        this.browserView = (BrowserView)((Object)Preconditions.checkNotNull((Object)((Object)browserView)));
    }

    void passFocusToNext() {
        Optional<Composite> parent = TabbingAssistant.nonDisposedParent(this.browserView);
        parent.ifPresent(parentComposite -> {
            Control sibling = this.findNextSibling((Composite)parentComposite);
            if (sibling == this.browserView) {
                BrowserWidget widget = ((BrowserImpl)this.browserView.getBrowser()).widget();
                widget.focus(FocusRequest.Cause.TRAVERSAL_FORWARD);
            } else {
                sibling.setFocus();
            }
        });
    }

    void passFocusToPrev() {
        Optional<Composite> parent = TabbingAssistant.nonDisposedParent(this.browserView);
        parent.ifPresent(parentComposite -> {
            Control sibling = this.findPrevSibling((Composite)parentComposite);
            if (sibling == this.browserView) {
                BrowserWidget widget = ((BrowserImpl)this.browserView.getBrowser()).widget();
                widget.focus(FocusRequest.Cause.TRAVERSAL_BACKWARD);
            } else {
                sibling.setFocus();
            }
        });
    }

    private static Optional<Composite> nonDisposedParent(Composite composite) {
        if (composite.isDisposed()) {
            return Optional.empty();
        }
        Composite parent = composite.getParent();
        if (parent == null || parent.isDisposed()) {
            return Optional.empty();
        }
        return Optional.of(parent);
    }

    private static List<Control> children(Composite parent) {
        return Arrays.stream(parent.getChildren()).collect(Collectors.toList());
    }

    private Control findNextSibling(Composite parent) {
        List<Control> siblings = TabbingAssistant.children(parent);
        int compositeIndex = siblings.indexOf((Object)this.browserView);
        if (compositeIndex == siblings.size() - 1) {
            return siblings.get(0);
        }
        return siblings.get(compositeIndex + 1);
    }

    private Control findPrevSibling(Composite parent) {
        List<Control> siblings = TabbingAssistant.children(parent);
        int siblingIndex = siblings.indexOf((Object)this.browserView);
        if (siblingIndex == 0) {
            return siblings.get(siblings.size() - 1);
        }
        return siblings.get(siblingIndex - 1);
    }
}

