/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.rpc.StartDrag;
import com.teamdev.jxbrowser.deps.com.google.protobuf.ByteString;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.internal.rpc.Bitmap;
import com.teamdev.jxbrowser.ui.internal.rpc.Size;
import com.teamdev.jxbrowser.view.swt.graphics.BitmapImage;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

final class DragImage {
    private static Image emptyImage;
    private final Image image;
    private final Point imageOffset;

    static DragImage createImage(StartDrag.Request params, Display display) {
        Point imageOffset = DragImage.toPoint(params.getDragImageOffset());
        Bitmap dragImageBitmap = params.getDragImage();
        Bitmap dragImage1xBitmap = params.getDragImage1X();
        if (!dragImageBitmap.size().isEmpty() && !dragImage1xBitmap.size().isEmpty()) {
            Bitmap bitmap = Environment.isWindows() ? dragImageBitmap : dragImage1xBitmap;
            Image dragImage = BitmapImage.toToolkit((Device)display, (com.teamdev.jxbrowser.ui.Bitmap)bitmap);
            if (Environment.isMac()) {
                imageOffset.x = -imageOffset.x;
                imageOffset.y = -imageOffset.y;
            }
            return new DragImage(dragImage, imageOffset);
        }
        return new DragImage(DragImage.emptyImage(display), imageOffset);
    }

    private static Image emptyImage(Display display) {
        if (emptyImage == null) {
            emptyImage = DragImage.createEmptyImage(display);
        }
        return emptyImage;
    }

    private static Point toPoint(com.teamdev.jxbrowser.ui.internal.rpc.Point protoPoint) {
        return new Point(protoPoint.x(), protoPoint.y());
    }

    private DragImage(Image image, Point imageOffset) {
        this.image = image;
        this.imageOffset = imageOffset;
    }

    Image toToolkit() {
        return this.image;
    }

    Point offset() {
        return this.imageOffset;
    }

    private static Image createEmptyImage(Display display) {
        Size oneByOnePixel = Size.newBuilder().setWidth(1).setHeight(1).build();
        ByteString singlePixel = ByteString.copyFrom((byte[])new byte[]{0, 0, 0, 0});
        Bitmap bitmap = Bitmap.newBuilder().setSize(oneByOnePixel).setPixels(singlePixel).build();
        return BitmapImage.toToolkit((Device)display, (com.teamdev.jxbrowser.ui.Bitmap)bitmap);
    }
}

