/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.DragAndDrop;
import com.teamdev.jxbrowser.browser.internal.callback.DragAndDropCallback;
import com.teamdev.jxbrowser.browser.internal.callback.StartDragCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.DragCursorUpdated;
import com.teamdev.jxbrowser.browser.internal.rpc.DragOperation;
import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.StartDrag;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.view.swt.internal.OffScreenRenderWidget;
import com.teamdev.jxbrowser.view.swt.internal.dnd.BrowserDragContext;
import com.teamdev.jxbrowser.view.swt.internal.dnd.DataType;
import com.teamdev.jxbrowser.view.swt.internal.dnd.DragImage;
import com.teamdev.jxbrowser.view.swt.internal.dnd.DragOperations;
import com.teamdev.jxbrowser.view.swt.internal.dnd.SupportedDataTypes;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;

final class DragLifecycleEvents {
    private final BrowserDragContext context;
    private final OffScreenRenderWidget composite;
    private Subscription dragCursorUpdated;
    private DragOperation cursor;

    static DragLifecycleEvents newInstance(OffScreenRenderWidget composite, BrowserDragContext context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)composite);
        return new DragLifecycleEvents(context, composite);
    }

    private DragLifecycleEvents(BrowserDragContext context, OffScreenRenderWidget composite) {
        this.context = context;
        this.composite = composite;
        this.cursor = DragOperation.OPERATION_NONE;
    }

    void startForwarding() {
        this.dragAndDrop().set(StartDragCallback.class, (DragAndDropCallback)((StartDragCallback)this::onDragStarted));
        this.dragCursorUpdated = this.composite.browserWidget().on(DragCursorUpdated.class, this::rememberCursor);
    }

    void stopForwarding() {
        this.dragAndDrop().remove(StartDragCallback.class);
        this.dragCursorUpdated.unsubscribe();
    }

    private void rememberCursor(DragCursorUpdated event) {
        this.cursor = event.getDragOperation();
    }

    private StartDrag.Response onDragStarted(StartDrag.Request request) {
        DropData dropData = request.getDropData();
        DragImage image = DragImage.createImage(request, this.composite.getDisplay());
        this.context.browserDragOperation(dropData, image);
        this.composite.getDisplay().asyncExec(() -> {
            DragSource dragSource = new DragSource((Control)this.composite, 15);
            Transfer[] transfers = SupportedDataTypes.findTransfers(dropData);
            dragSource.setTransfer(transfers);
            dragSource.addDragListener((DragSourceListener)new DragListener(dragSource, this.composite.browserWidget()));
        });
        return StartDrag.Response.newBuilder().build();
    }

    private DragAndDrop dragAndDrop() {
        return this.composite.browserWidget().browser().dragAndDrop();
    }

    private final class DragListener
    implements DragSourceListener {
        private final DragSource dragSource;
        private final BrowserWidget widget;

        private DragListener(DragSource dragSource, BrowserWidget widget) {
            this.dragSource = dragSource;
            this.widget = widget;
        }

        public void dragStart(DragSourceEvent event) {
            event.doit = DragLifecycleEvents.this.context.browserDragOperation().isPresent();
        }

        public void dragSetData(DragSourceEvent event) {
            DragLifecycleEvents.this.context.browserDragOperation().ifPresent(operation -> {
                org.eclipse.swt.graphics.Point offset = operation.dragImage().offset();
                event.offsetX = offset.x;
                event.offsetY = offset.y;
                for (DataType<Transfer, ?> dataType : SupportedDataTypes.supportedTypes()) {
                    if (!dataType.isPresentedIn(event.dataType)) continue;
                    event.data = dataType.read(operation.dropData());
                }
                event.detail = DragOperations.convert(DragLifecycleEvents.this.cursor);
                event.image = operation.dragImage().toToolkit();
            });
        }

        public void dragFinished(DragSourceEvent event) {
            DragOperation dragOperation = DragOperations.convert(event.detail);
            this.widget.dragEnd(Point.empty(), Point.empty(), dragOperation);
            DragLifecycleEvents.this.context.resetBrowserDragOperation();
            this.dragSource.dispose();
        }
    }
}

