/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.rpc.DragCursorUpdated;
import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.event.internal.rpc.KeyModifiers;
import com.teamdev.jxbrowser.view.swt.internal.OffScreenRenderWidget;
import com.teamdev.jxbrowser.view.swt.internal.dnd.BrowserDragContext;
import com.teamdev.jxbrowser.view.swt.internal.dnd.DragOperations;
import com.teamdev.jxbrowser.view.swt.internal.dnd.SupportedDataTypes;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;

final class DropTargetListener
implements org.eclipse.swt.dnd.DropTargetListener {
    private final BrowserWidget widget;
    private final BrowserDragContext context;
    private final OffScreenRenderWidget composite;
    private Subscription dragCursorUpdated;
    private int currentDropOperation;
    private KeyModifiers keyModifiers;

    static DropTargetListener newInstance(OffScreenRenderWidget composite, BrowserDragContext context) {
        Preconditions.checkNotNull((Object)composite);
        return new DropTargetListener(composite, context);
    }

    private DropTargetListener(OffScreenRenderWidget composite, BrowserDragContext context) {
        this.widget = composite.browserWidget();
        this.composite = composite;
        this.context = context;
        this.keyModifiers = KeyModifiers.newBuilder().build();
        this.currentDropOperation = 0;
    }

    public void drop(DropTargetEvent event) {
        Point screenPoint = Point.of((int)event.x, (int)event.y);
        Point localPoint = this.screenToLocal(event.x, event.y);
        if (Environment.isLinux() && this.context.browserDragOperation().isPresent()) {
            BrowserDragContext.CurrentDragOperation operation = this.context.browserDragOperation().get();
            this.performDrop(operation.dropData(), localPoint, screenPoint, event);
        } else {
            DropData.Builder dropData = DropData.newBuilder();
            HashSet<TransferData> dataTypes = new HashSet<TransferData>(Arrays.asList(event.dataTypes));
            dataTypes.add(event.currentDataType);
            for (TransferData transferData : dataTypes) {
                SupportedDataTypes.supportedTypes().forEach(dataType -> dataType.fillDropData(transferData, dropData));
            }
            this.performDrop(dropData.build(), localPoint, screenPoint, event);
        }
    }

    public void dragEnter(DropTargetEvent event) {
        if (this.context.browserDragOperation().isEmpty() && !this.context.isExternalDragEnabled()) {
            event.detail = 0;
            return;
        }
        DropMetadata.Builder metadata = DropMetadata.newBuilder();
        for (TransferData transferData : event.dataTypes) {
            SupportedDataTypes.supportedTypes().forEach(dataType -> dataType.fillMetadata(transferData, metadata));
        }
        this.context.browserDragOperation().ifPresent(operation -> {
            DropData.CustomData customData = operation.dropData().getCustomData();
            customData.getTypesList().forEach(arg_0 -> ((DropMetadata.Builder)metadata).addCustomDataTypes(arg_0));
        });
        Point localPoint = this.screenToLocal(event.x, event.y);
        Point screenPoint = Point.of((int)event.x, (int)event.y);
        this.keyModifiers = this.keyModifiers(event.detail);
        this.widget.dragEnter(metadata.build(), localPoint, screenPoint, DragOperations.toDragOperationMask(15), this.keyModifiers);
        this.dragCursorUpdated = this.widget.on(DragCursorUpdated.class, dragCursorUpdatedEvent -> {
            this.currentDropOperation = DragOperations.convert(dragCursorUpdatedEvent.getDragOperation());
        });
    }

    public void dragLeave(DropTargetEvent event) {
        if (this.isCursorOutsideComposite()) {
            this.widget.dragLeave();
        }
    }

    public void dragOver(DropTargetEvent event) {
        Point localPoint = this.screenToLocal(event.x, event.y);
        Point screenPoint = Point.of((int)event.x, (int)event.y);
        this.widget.dragOver(localPoint, screenPoint, DragOperations.toDragOperationMask(15), this.keyModifiers);
        event.detail = this.currentDropOperation;
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.keyModifiers = this.keyModifiers(event.detail);
        event.detail = this.currentDropOperation;
    }

    public void dropAccept(DropTargetEvent event) {
    }

    private void performDrop(DropData dropData, Point localPoint, Point screenPoint, DropTargetEvent event) {
        this.widget.drop(dropData, localPoint, screenPoint, this.keyModifiers);
        event.detail = this.currentDropOperation;
        this.keyModifiers = KeyModifiers.newBuilder().build();
        this.dragCursorUpdated.unsubscribe();
    }

    private Point screenToLocal(int screenX, int screenY) {
        org.eclipse.swt.graphics.Point locationOnScreen = this.composite.toDisplay(0, 0);
        int localX = screenX - locationOnScreen.x;
        int localY = screenY - locationOnScreen.y;
        Point point = Point.of((int)localX, (int)localY);
        return point;
    }

    private boolean isCursorOutsideComposite() {
        org.eclipse.swt.graphics.Point cursorLocation = Display.getCurrent().getCursorLocation();
        org.eclipse.swt.graphics.Point relativeCursorLocation = this.composite.toControl(cursorLocation);
        boolean moreNorthWestern = relativeCursorLocation.x < 0 || relativeCursorLocation.y < 0;
        boolean moreSouthEastern = relativeCursorLocation.x > this.composite.getSize().x || relativeCursorLocation.y > this.composite.getSize().y;
        return moreNorthWestern || moreSouthEastern;
    }

    private KeyModifiers keyModifiers(int operation) {
        KeyModifiers.Builder builder = KeyModifiers.newBuilder();
        return switch (operation) {
            case 2 -> {
                if (Environment.isMac()) {
                    yield builder.setMetaDown(true).build();
                }
                yield builder.setShiftDown(true).build();
            }
            case 1 -> {
                if (Environment.isMac()) {
                    yield builder.setAltDown(true).build();
                }
                yield builder.setControlDown(true).build();
            }
            case 4 -> {
                if (Environment.isMac()) {
                    yield builder.setAltDown(true).setMetaDown(true).build();
                }
                yield builder.setControlDown(true).setShiftDown(true).build();
            }
            default -> builder.build();
        };
    }
}

