/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal.menu;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.ShowContextMenuCallback;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.menu.SpellCheckMenu;
import com.teamdev.jxbrowser.spellcheck.Dictionary;
import com.teamdev.jxbrowser.view.swt.internal.menu.ContextMenu;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public final class SpellingContextMenu
extends ContextMenu {
    private final Browser browser;
    private final SpellCheckMenu spellCheckMenu;

    public SpellingContextMenu(Browser browser, SpellCheckMenu spellCheckMenu) {
        Preconditions.checkNotNull((Object)browser);
        Preconditions.checkNotNull((Object)spellCheckMenu);
        this.browser = browser;
        this.spellCheckMenu = spellCheckMenu;
    }

    @Override
    public void init(Menu menu, ShowContextMenuCallback.Action callback) {
        this.addSuggestionMenuItems(menu, callback);
        this.addAddToDictionaryMenuItem(menu, callback);
    }

    private void addSuggestionMenuItems(Menu contextMenu, ShowContextMenuCallback.Action callback) {
        this.spellCheckMenu.dictionarySuggestions().forEach(dictionarySuggestion -> {
            MenuItem menuItem = new MenuItem(contextMenu, 8);
            menuItem.setText(dictionarySuggestion);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter((String)dictionarySuggestion, callback){
                final /* synthetic */ String val$dictionarySuggestion;
                final /* synthetic */ ShowContextMenuCallback.Action val$callback;
                {
                    this.val$dictionarySuggestion = string;
                    this.val$callback = action;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SpellingContextMenu.this.browser.replaceMisspelledWord(this.val$dictionarySuggestion);
                    this.val$callback.close();
                }
            });
        });
        new MenuItem(contextMenu, 2);
    }

    private void addAddToDictionaryMenuItem(Menu contextMenu, final ShowContextMenuCallback.Action callback) {
        MenuItem menuItem = new MenuItem(contextMenu, 8);
        menuItem.setText(this.spellCheckMenu.addToDictionaryMenuItemText());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Dictionary dictionary = SpellingContextMenu.this.browser.engine().spellChecker().customDictionary();
                dictionary.add(SpellingContextMenu.this.spellCheckMenu.misspelledWord());
                callback.close();
            }
        });
    }
}

