/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.BrowserCallback;
import com.teamdev.jxbrowser.browser.callback.CreatePopupCallback;
import com.teamdev.jxbrowser.browser.callback.internal.ShowTextReplacementMenuCallback;
import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.callback.BrowserWidgetCallback;
import com.teamdev.jxbrowser.browser.internal.callback.ShowDropdownCallback;
import com.teamdev.jxbrowser.callback.Advisable;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.callback.internal.DefaultCallbacks;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.internal.platform.win.MessageLoopHelper;
import com.teamdev.jxbrowser.internal.ui.HeadlessToolkits;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.javafx.DragAndDrop;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultAlertCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultBeforeFormRepostCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultBeforeUnloadCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultConfirmCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultOpenExtensionActionPopupCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultOpenExternalAppCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultOpenFileCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultOpenFilesCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultOpenFolderCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultOpenPopupCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultPrintCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultPromptCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultRequestPdfDocumentPasswordCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultSaveAsPdfCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultSaveCreditCardCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultSaveFileCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultSavePasswordCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultSaveUserDataProfileCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultSelectClientCertificateCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultSelectColorCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultShowContextMenuCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultShowDropdownCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultStartCaptureSessionCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultStartDownloadCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultUpdatePasswordCallback;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultUpdateUserDataProfileCallback;
import com.teamdev.jxbrowser.view.javafx.callback.internal.DefaultShowSuggestionsCallback;
import com.teamdev.jxbrowser.view.javafx.callback.internal.DefaultShowTextReplacementMenuCallback;
import com.teamdev.jxbrowser.view.javafx.internal.RenderWidget;
import com.teamdev.jxbrowser.view.javafx.internal.WindowedWidget;
import com.teamdev.jxbrowser.view.javafx.internal.menu.SuggestionsListener;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.Graphics2dRenderWidget;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.IoSurfaceRenderWidget;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.OffScreenRenderWidget;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;

public final class BrowserView
extends StackPane {
    private static final String JAVAFX_SCALE_PROPERTY = "glass.gtk.uiScale";
    private static final int GTK_VERSION_2 = 2;
    private final BrowserImpl browser;
    private final DragAndDrop dragAndDrop;
    private final DefaultCallbacks<BrowserCallback> defaultCallbacks;
    private Subscription onBrowserClosed;
    private final RenderingMode renderingMode;
    private RenderWidget<?> renderWidget;

    public static BrowserView newInstance(Browser browser) {
        BrowserView.checkEnvironment();
        return new BrowserView(browser);
    }

    private BrowserView(Browser browser) {
        Preconditions.checkNotNull((Object)browser);
        Logger.debug((String)"UI Toolkit: JavaFX");
        boolean nativeInputMethod = Boolean.getBoolean("jxbrowser.native.input.enabled");
        Logger.debug((String)String.format("Input method: %s", nativeInputMethod ? "native" : "Java"));
        this.browser = (BrowserImpl)browser;
        this.renderingMode = browser.engine().options().renderingMode();
        if (MessageLoopHelper.isSupported()) {
            MessageLoopHelper.markAsMessageLoopThread();
        }
        if (Environment.isLinux() && SystemProperties.hasProperty((String)JAVAFX_SCALE_PROPERTY)) {
            double scaleFactor = Double.parseDouble(System.getProperty(JAVAFX_SCALE_PROPERTY));
            this.browser.widget().setForcedScaleFactor(scaleFactor);
        }
        this.defaultCallbacks = this.defaultCallbacks();
        this.renderWidget = this.createRenderWidget(this.browserWidget());
        SuggestionsListener suggestionsListener = new SuggestionsListener(browser);
        this.onBrowserClosed = browser.on(BrowserClosed.class, event -> {
            this.defaultCallbacks.unregister();
            this.onBrowserClosed.unsubscribe();
            suggestionsListener.stopEventsProcessing();
            this.unregisterCustomDropdownIfNecessary();
            this.unregisterTextCompletionCallbackIfNecessary();
            this.renderWidget = null;
        });
        this.dragAndDrop = new DragAndDropSupport();
        suggestionsListener.startEventsProcessing();
        this.defaultCallbacks.register();
    }

    private BrowserWidget browserWidget() {
        return this.browser.widget();
    }

    private DefaultCallbacks<BrowserCallback> defaultCallbacks() {
        this.registerCustomDropdownIfNecessary();
        this.registerTextCompletionCallbackIfNecessary();
        return DefaultCallbacks.of((Advisable)this.browser).add((Callback)((CreatePopupCallback)params -> CreatePopupCallback.Response.create())).add((Callback)new DefaultOpenPopupCallback()).add((Callback)new DefaultAlertCallback(this)).add((Callback)new DefaultConfirmCallback(this)).add((Callback)new DefaultPromptCallback(this)).add((Callback)new DefaultOpenFileCallback(this)).add((Callback)new DefaultOpenFilesCallback(this)).add((Callback)new DefaultOpenFolderCallback(this)).add((Callback)new DefaultSaveFileCallback(this)).add((Callback)new DefaultSaveAsPdfCallback(this)).add((Callback)new DefaultSelectColorCallback(this)).add((Callback)new DefaultBeforeUnloadCallback(this)).add((Callback)new DefaultSelectClientCertificateCallback(this)).add((Callback)new DefaultBeforeFormRepostCallback(this)).add((Callback)new DefaultPrintCallback()).add((Callback)new DefaultShowContextMenuCallback(this)).add((Callback)new DefaultStartDownloadCallback(this)).add((Callback)new DefaultStartCaptureSessionCallback()).add((Callback)new DefaultOpenExternalAppCallback(this)).add((Callback)new DefaultShowSuggestionsCallback(this)).add((Callback)new DefaultSavePasswordCallback(this)).add((Callback)new DefaultUpdatePasswordCallback(this)).add((Callback)new DefaultSaveCreditCardCallback(this)).add((Callback)new DefaultSaveUserDataProfileCallback(this)).add((Callback)new DefaultUpdateUserDataProfileCallback(this)).add((Callback)new DefaultRequestPdfDocumentPasswordCallback(this)).add((Callback)new DefaultOpenExtensionActionPopupCallback()).build();
    }

    private void registerCustomDropdownIfNecessary() {
        if (this.isCustomDropdownsEnabled()) {
            this.browserWidget().set(ShowDropdownCallback.class, (BrowserWidgetCallback)new DefaultShowDropdownCallback(this));
        }
    }

    private void registerTextCompletionCallbackIfNecessary() {
        if (this.isMacNativeInput()) {
            this.browser.set(ShowTextReplacementMenuCallback.class, (BrowserCallback)new DefaultShowTextReplacementMenuCallback(this));
        }
    }

    private void unregisterCustomDropdownIfNecessary() {
        if (this.isCustomDropdownsEnabled()) {
            this.browser.widget().remove(ShowDropdownCallback.class);
        }
    }

    private void unregisterTextCompletionCallbackIfNecessary() {
        if (this.isMacNativeInput()) {
            this.browser.remove(ShowTextReplacementMenuCallback.class);
        }
    }

    private boolean isCustomDropdownsEnabled() {
        return HeadlessToolkits.isHeadlessToolkit() && this.renderingMode == RenderingMode.OFF_SCREEN;
    }

    private boolean isMacNativeInput() {
        return Environment.isMac() && Boolean.getBoolean("jxbrowser.native.input.enabled");
    }

    private RenderWidget<?> createRenderWidget(BrowserWidget widget) {
        if (this.renderingMode == RenderingMode.OFF_SCREEN) {
            return new Graphics2dRenderWidget(widget, this);
        }
        if (this.renderingMode == RenderingMode.HARDWARE_ACCELERATED) {
            if (Environment.isMac()) {
                return new IoSurfaceRenderWidget(widget, this);
            }
            if (Environment.isWindows() || Environment.isLinux()) {
                return new WindowedWidget(widget, this);
            }
        }
        throw new IllegalStateException("Unsupported operating system");
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void requestFocus() {
        super.requestFocus();
        this.renderWidget.node().ifPresent(Node::requestFocus);
    }

    public DragAndDrop dragAndDrop() {
        return this.dragAndDrop;
    }

    private static void checkEnvironment() {
        if (Environment.isLinux()) {
            int gtkVersion = SystemProperties.getAsInt((String)"jdk.gtk.version", (int)Integer.MAX_VALUE);
            Preconditions.checkState((gtkVersion != 2 ? 1 : 0) != 0, (String)String.format("Unsupported GTK version: %d.", gtkVersion), (Object[])new Object[0]);
        }
    }

    private class DragAndDropSupport
    implements DragAndDrop {
        private DragAndDropSupport() {
        }

        @Override
        public void enable() {
            BrowserView.this.browser.dragAndDrop().enable();
            RenderWidget<?> renderWidget = BrowserView.this.renderWidget;
            if (renderWidget instanceof OffScreenRenderWidget) {
                OffScreenRenderWidget widget = (OffScreenRenderWidget)renderWidget;
                widget.enableDragAndDrop();
            }
        }

        @Override
        public void disable() {
            RenderWidget<?> renderWidget = BrowserView.this.renderWidget;
            if (renderWidget instanceof OffScreenRenderWidget) {
                OffScreenRenderWidget widget = (OffScreenRenderWidget)renderWidget;
                widget.disableDragAndDrop();
            }
            BrowserView.this.browser.dragAndDrop().disable();
        }

        @Override
        public boolean isEnabled() {
            return BrowserView.this.browser.dragAndDrop().isEnabledSync();
        }

        @Override
        public void enableExternalDrag() {
            RenderWidget<?> renderWidget = BrowserView.this.renderWidget;
            if (renderWidget instanceof OffScreenRenderWidget) {
                OffScreenRenderWidget widget = (OffScreenRenderWidget)renderWidget;
                widget.setEnabledExternalDrag(true);
            }
            BrowserView.this.browser.dragAndDrop().enableExternalDrag();
        }

        @Override
        public void disableExternalDrag() {
            RenderWidget<?> renderWidget = BrowserView.this.renderWidget;
            if (renderWidget instanceof OffScreenRenderWidget) {
                OffScreenRenderWidget widget = (OffScreenRenderWidget)renderWidget;
                widget.setEnabledExternalDrag(false);
            }
            BrowserView.this.browser.dragAndDrop().disableExternalDrag();
        }

        @Override
        public boolean isExternalDragEnabled() {
            return BrowserView.this.browser.dragAndDrop().isExternalDragEnabledSync();
        }
    }
}

