/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.dialog;

import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import com.teamdev.jxbrowser.ui.internal.Action;
import com.teamdev.jxbrowser.ui.internal.DefaultDialog;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public abstract class FxDialog<D extends FxDialog<D>>
extends DefaultDialog<D> {
    private final Window owner;
    private Stage stage;

    FxDialog(FxDialogBuilder<D, ?> builder) {
        super(builder);
        this.owner = builder.owner;
    }

    public void open() {
        this.stage = new Stage(StageStyle.UTILITY);
        this.stage.initOwner(this.owner);
        this.stage.setWidth(400.0);
        this.stage.setResizable(false);
        this.stage.initModality(this.owner != null ? Modality.WINDOW_MODAL : Modality.APPLICATION_MODAL);
        this.stage.setTitle(this.title);
        VBox contentPanel = this.createContentPanel();
        this.fillContentPanel((Pane)contentPanel);
        VBox root = new VBox();
        root.setStyle("-fx-background-color: #F0F0F0;");
        root.setPadding(new Insets(8.0));
        root.getChildren().addAll((Object[])new Node[]{contentPanel, this.createButtonPanel()});
        this.stage.setOnCloseRequest(event -> {
            if (!this.actionSelected) {
                this.defaultCallback.run();
            }
        });
        Scene scene = new Scene((Parent)root);
        this.stage.setScene(scene);
        this.stage.showAndWait();
    }

    protected abstract void fillContentPanel(Pane var1);

    private VBox createContentPanel() {
        VBox contentBox = new VBox(10.0);
        Label messageLabel = new Label();
        messageLabel.setWrapText(true);
        messageLabel.setTextAlignment(TextAlignment.LEFT);
        messageLabel.setText(this.message);
        messageLabel.setPrefWidth(370.0);
        contentBox.setAlignment(Pos.CENTER_LEFT);
        contentBox.getChildren().add((Object)messageLabel);
        return contentBox;
    }

    private HBox createButtonPanel() {
        HBox buttonBox = new HBox(10.0);
        buttonBox.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        buttonBox.setAlignment(Pos.BOTTOM_RIGHT);
        for (Action action : this.actions) {
            Button button = new Button(action.label());
            button.setMinWidth(75.0);
            button.setOnAction(event -> {
                this.actionSelected = true;
                action.callback().accept((FxDialog)this.self());
                this.stage.close();
            });
            buttonBox.getChildren().add((Object)button);
        }
        return buttonBox;
    }

    static abstract class FxDialogBuilder<D extends FxDialog<D>, B extends FxDialogBuilder<D, B>>
    extends DefaultDialog.Builder<D, B> {
        private final Window owner;

        protected FxDialogBuilder(Window owner, String message) {
            super(message);
            StringPreconditions.checkNotNullEmptyOrBlank((String)message);
            this.owner = (Window)Preconditions.checkNotNull((Object)owner);
        }
    }
}

