/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.rpc.DragOperation;
import com.teamdev.jxbrowser.view.internal.BiConverter;
import javafx.scene.input.TransferMode;

final class TransferModes {
    private static final BiConverter<TransferMode, DragOperation> CONVERTER = new OperationConverter();

    private TransferModes() {
    }

    static TransferMode[] of(DragOperation dragOperation) {
        if (dragOperation == DragOperation.OPERATION_NONE) {
            return TransferMode.NONE;
        }
        TransferMode transferMode = (TransferMode)CONVERTER.reverse().convert((Object)dragOperation);
        if (transferMode == null) {
            return TransferModes.singletonArray(TransferMode.COPY);
        }
        return TransferModes.singletonArray(transferMode);
    }

    static DragOperation toDragOperation(TransferMode transferMode) {
        DragOperation dragOperation = (DragOperation)CONVERTER.convert((Object)transferMode);
        if (dragOperation == null) {
            return DragOperation.OPERATION_NONE;
        }
        return dragOperation;
    }

    static int toDragOperationMask(TransferMode ... transferModes) {
        int result = 0;
        for (TransferMode transferMode : transferModes) {
            DragOperation operation = (DragOperation)CONVERTER.convert((Object)transferMode);
            if (operation == null) continue;
            result |= operation.getNumber();
        }
        return result;
    }

    private static TransferMode[] singletonArray(TransferMode transferMode) {
        return new TransferMode[]{transferMode};
    }

    private static class OperationConverter
    extends BiConverter<TransferMode, DragOperation> {
        private OperationConverter() {
        }

        protected DragOperation doForward(TransferMode transferMode) {
            if (transferMode == TransferMode.COPY) {
                return DragOperation.OPERATION_COPY;
            }
            if (transferMode == TransferMode.MOVE) {
                return DragOperation.OPERATION_MOVE;
            }
            if (transferMode == TransferMode.LINK) {
                return DragOperation.OPERATION_LINK;
            }
            return DragOperation.OPERATION_NONE;
        }

        protected TransferMode doBackward(DragOperation dragOperation) {
            if (dragOperation == DragOperation.OPERATION_COPY) {
                return TransferMode.COPY;
            }
            if (dragOperation == DragOperation.OPERATION_MOVE) {
                return TransferMode.MOVE;
            }
            if (dragOperation == DragOperation.OPERATION_LINK) {
                return TransferMode.LINK;
            }
            return TransferMode.COPY;
        }
    }
}

