#  Copyright (c) 2000-2026 TeamDev. All rights reserved.
#  TeamDev PROPRIETARY and CONFIDENTIAL.
#  Use is subject to license terms.

from common import *


def get_sub_path(target_dir, target_file):
    file_path = os.path.abspath(target_file)
    dir_path = os.path.abspath(target_dir) + os.sep
    return file_path.replace(dir_path, '')


def get_arch_suffix(target_os, target_cpu):
    if target_cpu == "arm64":
        return "64-arm" if target_os == "win" else "-arm"
    if target_cpu == "x64":
        return "64" if target_os == "win" else ""
    if target_cpu == "x86":
        return "32"
    raise ValueError(f"Unsupported CPU architecture: {target_cpu}")


def get_output_file_name(target_os, target_cpu):
    arch_suffix = get_arch_suffix(target_os, target_cpu)
    if target_os == "mac":
        return f"chromium-mac{arch_suffix}.info"
    if target_os == "win":
        return f"chromium-win{arch_suffix}.info"
    if target_os == "linux":
        return f"chromium-linux64{arch_suffix}.info"
    raise ValueError(f"Unsupported OS: {target_os}")


def generate_chromium_info_file(source_dir, target_os, target_cpu, target_dir):
    chromium_file_path_to_file_size_map = {}

    for root, dirs, files in os.walk(source_dir):
        for chromium_file in files:
            chromium_file_path = os.path.join(root, chromium_file)
            if os.path.isfile(chromium_file_path):
                chromium_file_rel_path = get_sub_path(source_dir, chromium_file_path)
                chromium_file_size = os.path.getsize(chromium_file_path)
                chromium_file_path_to_file_size_map[chromium_file_rel_path] = chromium_file_size

    content = ''
    for chromium_file_path in chromium_file_path_to_file_size_map:
        file_size = chromium_file_path_to_file_size_map[chromium_file_path]
        # The '\' file path separator on Windows must be replaced with '\\'.
        chromium_file_path = chromium_file_path.replace('\\', '\\\\')
        # The ' ' symbol in the file path must be replaced with '\ '.
        chromium_file_path = chromium_file_path.replace(' ', '\\ ')
        content += chromium_file_path + '=' + str(file_size) + '\n'

    out_file_path = os.path.join(target_dir, get_output_file_name(target_os, target_cpu))
    with open(out_file_path, 'w') as output_file:
        output_file.write(content)
