// Copyright (c) 2000-2026 TeamDev. All rights reserved.
// TeamDev PROPRIETARY and CONFIDENTIAL.
// Use is subject to license terms.

#ifndef CORE_MAIN_UI_X11_DRAG_DROP_CLIENT_H_
#define CORE_MAIN_UI_X11_DRAG_DROP_CLIENT_H_

#include "ui/base/x/x11_drag_drop_client.h"
#include "ui/events/platform/platform_event_dispatcher.h"
#include "ui/events/platform/x11/x11_event_source.h"
#include "ui/gfx/geometry/rect.h"

namespace platinum {

class LinuxDndProxyWindow;
class XDragDropClient : public ::ui::XDragDropClient {
 public:
  XDragDropClient(Delegate* delegate, x11::Window xwindow);

  ~XDragDropClient() override;

  void SetViewBounds(const gfx::Rect& bounds);

  void OnViewHidden();
  void OnViewShown();
  void OnAttach(x11::Window parent_window);
  void OnDetach();

  x11::Window GetProxyWindow(x11::Window xid) const override;
  x11::Window GetProxyWindow() const override;
  x11::Window GetOnDndStatusTargetWindow(const x11::ClientMessageEvent& event,
                                         x11::Window source_current_window) const override;

  bool IsMouseInsideBrowserView() const;
  bool IsMouseInsideNativeWindow() const;

  bool is_visible() { return is_visible_; }

  x11::Window FindWindowFor(const gfx::Point& screen_point) override;

  void SendXClientEvent(x11::Window xid, const x11::ClientMessageEvent& xev) override;

 private:
  x11::Window parent_window_ = x11::Window::None;
  x11::Window native_window_ = x11::Window::None;
  gfx::Rect view_bounds_;

  raw_ptr<LinuxDndProxyWindow> dnd_proxy_window_ = nullptr;
  bool is_visible_ = false;

  // Checks whether the window has a registered XDragDropClient client in this process.
  bool IsLocalWindow(x11::Window window) const;
};

}  // namespace platinum

#endif  // CORE_MAIN_UI_X11_DRAG_DROP_CLIENT_H_
