// Copyright (c) 2000-2026 TeamDev. All rights reserved.
// TeamDev PROPRIETARY and CONFIDENTIAL.
// Use is subject to license terms.

#ifndef INCLUDE_BROWSER_TYPE_H_
#define INCLUDE_BROWSER_TYPE_H_

namespace views {
class Widget;
}

namespace platinum {

// Defines the types of browser instances that can be created in Platinum.
enum class BrowserType {
  // A standard Chromium browser instance.
  kDefault,

  // An embeddable browser instance.
  kEmbeddable,

  // A standalone browser instance in a desktop hybrid application.
  kApp
};

// Returns the browser type for the given widget.
BrowserType GetBrowserTypeForWidget(views::Widget* widget);

}  // namespace platinum

#endif  // INCLUDE_BROWSER_TYPE_H_
