/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.view.swt.internal.BrowserComposite;
import javax.annotation.Nullable;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Shell;

final class ShellListeners {
    private final BrowserComposite browserComposite;
    private final ControlListener shellMovedListener;
    private final ShellListener windowIconifiedListener;
    @Nullable
    private Shell observedShell;

    ShellListeners(BrowserComposite browserComposite) {
        this.browserComposite = (BrowserComposite)((Object)Preconditions.checkNotNull((Object)((Object)browserComposite)));
        this.shellMovedListener = new ShellMovedListener();
        this.windowIconifiedListener = new WindowIconifiedListener();
    }

    void attach(Shell shell) {
        if (this.observedShell == null) {
            this.observedShell = shell;
            shell.addControlListener(this.shellMovedListener);
            shell.addShellListener(this.windowIconifiedListener);
        }
    }

    void detach() {
        if (this.observedShell != null) {
            if (!this.observedShell.isDisposed()) {
                this.observedShell.removeControlListener(this.shellMovedListener);
                this.observedShell.removeShellListener(this.windowIconifiedListener);
            }
            this.observedShell = null;
        }
    }

    private final class ShellMovedListener
    extends ControlAdapter {
        private ShellMovedListener() {
        }

        public void controlMoved(ControlEvent event) {
            ShellListeners.this.browserComposite.notifyBoundsUpdated();
        }
    }

    private final class WindowIconifiedListener
    extends ShellAdapter {
        private WindowIconifiedListener() {
        }

        public void shellIconified(ShellEvent event) {
            this.browserWidget().minimize();
        }

        public void shellDeiconified(ShellEvent event) {
            this.browserWidget().restore();
        }

        private BrowserWidget browserWidget() {
            return ShellListeners.this.browserComposite.browserWidget();
        }
    }
}

