/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal;

import com.teamdev.jxbrowser.internal.Preconditions;

public final class JavaFxVersion {
    public static final int JAVAFX_14 = 14;
    static final String JAVAFX_VERSION = "javafx.version";
    private static final int VERSION_PARTS = 3;

    public static boolean isOlderThan(int version) {
        Preconditions.checkArgument((version >= 2 ? 1 : 0) != 0);
        return JavaFxVersion.major() < version;
    }

    private JavaFxVersion() {
    }

    private static int major() {
        String wholeVersion = System.getProperty(JAVAFX_VERSION);
        String[] split = wholeVersion.split("\\.", 3);
        if (split.length > 0) {
            String majorVersion = split[0];
            return Integer.parseInt(majorVersion);
        }
        throw new IllegalStateException("Couldn't detect or parse JavaFX version");
    }
}

