/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.dialog;

import com.teamdev.jxbrowser.view.javafx.internal.dialog.FxDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.Pane;
import javafx.stage.Window;

public final class SelectDialog
extends FxDialog<SelectDialog> {
    private final ListView<String> listView;
    private final List<String> items;

    public static Builder newBuilder(Window owner, String message) {
        return new Builder(owner, message);
    }

    private SelectDialog(Builder builder) {
        super(builder);
        this.items = List.copyOf(builder.items);
        this.listView = new ListView();
    }

    @Override
    protected void fillContentPanel(Pane contentPane) {
        this.listView.setItems(FXCollections.observableArrayList(this.items));
        this.listView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.listView.getSelectionModel().select(0);
        contentPane.getChildren().add(this.listView);
    }

    public String selectedValue() {
        return (String)this.listView.getSelectionModel().getSelectedItem();
    }

    protected SelectDialog self() {
        return this;
    }

    public static final class Builder
    extends FxDialog.FxDialogBuilder<SelectDialog, Builder> {
        private final List<String> items = new ArrayList<String>();

        private Builder(Window owner, String message) {
            super(owner, message);
        }

        public Builder addAllItems(Collection<String> items) {
            this.items.addAll(items);
            return this.self();
        }

        public SelectDialog createDialog() {
            return new SelectDialog(this);
        }

        protected Builder self() {
            return this;
        }
    }
}

