/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.DragAndDrop;
import com.teamdev.jxbrowser.browser.internal.callback.DragAndDropCallback;
import com.teamdev.jxbrowser.browser.internal.callback.StartDragCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.DragCursorUpdated;
import com.teamdev.jxbrowser.browser.internal.rpc.DragOperation;
import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.browser.internal.rpc.StartDrag;
import com.teamdev.jxbrowser.deps.com.google.protobuf.ByteString;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.event.internal.rpc.KeyModifiers;
import com.teamdev.jxbrowser.ui.internal.rpc.Bitmap;
import com.teamdev.jxbrowser.ui.internal.rpc.Size;
import com.teamdev.jxbrowser.view.javafx.internal.JavaFxVersion;
import com.teamdev.jxbrowser.view.javafx.internal.dnd.Clipboard;
import com.teamdev.jxbrowser.view.javafx.internal.dnd.DragContext;
import com.teamdev.jxbrowser.view.javafx.internal.dnd.TransferModes;
import com.teamdev.jxbrowser.view.javafx.internal.graphics.DragImage;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;

public final class DragAndDropBridge {
    private static final Image DUMMY_DRAG_IMAGE = DragImage.toToolkit((com.teamdev.jxbrowser.ui.Bitmap)Bitmap.newBuilder().setSize(Size.newBuilder().setWidth(1).setHeight(1).build()).setPixels(ByteString.copyFrom((byte[])new byte[]{0, 0, 0, 0})).build());
    private final DragContext context;
    private final BrowserWidget widget;
    private final DragAndDrop dragAndDrop;
    private final DragListener dragListener;
    private Node node;
    private State state;
    private boolean externalDragEnabled;
    private Subscription dragCursorUpdated;

    public DragAndDropBridge(BrowserWidget widget) {
        this.widget = widget;
        this.context = new DragContext();
        this.dragListener = new DragListener();
        this.state = State.DETACHED;
        this.dragAndDrop = widget.browser().dragAndDrop();
        this.externalDragEnabled = true;
    }

    public void attach(Node node) {
        if (this.state == State.ATTACHED) {
            return;
        }
        this.node = node;
        node.addEventHandler(DragEvent.ANY, (EventHandler)this.dragListener);
        this.dragAndDrop.set(StartDragCallback.class, (DragAndDropCallback)((StartDragCallback)this::startDrag));
        this.dragCursorUpdated = this.widget.on(DragCursorUpdated.class, this::updateDragCursor);
        this.state = State.ATTACHED;
    }

    public void detach() {
        if (this.state == State.DETACHED) {
            return;
        }
        this.context.endDragging();
        this.dragAndDrop.remove(StartDragCallback.class);
        this.dragCursorUpdated.unsubscribe();
        this.node.removeEventHandler(DragEvent.ANY, (EventHandler)this.dragListener);
        this.state = State.DETACHED;
        this.node = null;
    }

    public void setEnabledExternalDrag(boolean enabled) {
        this.externalDragEnabled = enabled;
    }

    public boolean isDragging() {
        return this.context.isDragging();
    }

    private StartDrag.Response startDrag(StartDrag.Request params) {
        DropData dropData = params.getDropData();
        com.teamdev.jxbrowser.ui.internal.rpc.Point imageOffset = params.getDragImageOffset();
        Bitmap dragImageBitmap = params.getDragImage();
        Bitmap dragImage1xBitmap = params.getDragImage1X();
        if (!dragImageBitmap.size().isEmpty() && !dragImage1xBitmap.size().isEmpty()) {
            Bitmap dragImage;
            Bitmap bitmap = dragImage = Environment.isWindows() ? dragImageBitmap : dragImage1xBitmap;
            if (Environment.isMac()) {
                Size size = dragImage1xBitmap.getSize();
                int originX = size.width() / 2;
                int originY = size.height() / 2;
                int offsetX = originX - imageOffset.x();
                int offsetY = -(originY - imageOffset.y());
                imageOffset = Point.of((int)offsetX, (int)offsetY);
            }
            this.context.startDragging(dropData, DragImage.toToolkit((com.teamdev.jxbrowser.ui.Bitmap)dragImage), (Point)imageOffset);
        } else {
            this.context.startDragging(dropData, DUMMY_DRAG_IMAGE, (Point)imageOffset);
        }
        return StartDrag.Response.newBuilder().build();
    }

    public boolean handleMouseEvent(MouseEvent event) {
        if (this.node == null) {
            return false;
        }
        if (event.getEventType().equals(MouseEvent.MOUSE_DRAGGED)) {
            event.setDragDetect(this.context.isDragging());
        }
        if (this.context.isDragging() && event.getEventType().equals(MouseEvent.DRAG_DETECTED)) {
            Dragboard dragboard = this.node.startDragAndDrop(TransferMode.ANY);
            Clipboard.of(dragboard).setContent(this.context.content());
            Point offset = this.context.imageOffset();
            this.setDragViewImage(dragboard, offset);
            return true;
        }
        return false;
    }

    private void updateDragCursor(DragCursorUpdated event) {
        this.context.operation(event.getDragOperation());
    }

    private void setDragViewImage(Dragboard dragboard, Point offset) {
        boolean dragViewWorks;
        boolean bl = dragViewWorks = !Environment.isLinux() || !JavaFxVersion.isOlderThan(14);
        if (dragViewWorks) {
            dragboard.setDragView(this.context.image(), (double)offset.x(), (double)offset.y());
        }
    }

    private class DragListener
    implements EventHandler<DragEvent> {
        private DragListener() {
        }

        public void handle(DragEvent event) {
            EventType eventType = event.getEventType();
            if (eventType.equals(DragEvent.DRAG_ENTERED)) {
                this.handleDragEntered(event);
            } else if (eventType.equals(DragEvent.DRAG_OVER)) {
                this.handleDragOver(event);
            } else if (eventType.equals(DragEvent.DRAG_EXITED)) {
                this.handleDragExited(event);
            } else if (eventType.equals(DragEvent.DRAG_DONE)) {
                this.handleDragDone(event);
            } else if (eventType.equals(DragEvent.DRAG_DROPPED)) {
                this.handleDragDropped(event);
            }
            event.consume();
        }

        private void handleDragEntered(DragEvent event) {
            if (!DragAndDropBridge.this.context.isDragging() && !DragAndDropBridge.this.externalDragEnabled) {
                return;
            }
            DropMetadata dropMetadata = Clipboard.of(event.getDragboard()).dropMetadata();
            int operation = TransferModes.toDragOperationMask(TransferMode.ANY);
            Point localPoint = this.getLocalPoint(event);
            Point screenPoint = this.getScreenPoint(event);
            KeyModifiers keyModifiers = this.keyModifiers(event);
            DragAndDropBridge.this.widget.dragEnter(dropMetadata, localPoint, screenPoint, operation, keyModifiers);
        }

        private void handleDragOver(DragEvent event) {
            event.acceptTransferModes(TransferModes.of(DragAndDropBridge.this.context.operation()));
            int operation = TransferModes.toDragOperationMask(TransferMode.ANY);
            Point localPoint = this.getLocalPoint(event);
            Point screenPoint = this.getScreenPoint(event);
            KeyModifiers keyModifiers = this.keyModifiers(event);
            DragAndDropBridge.this.widget.dragOver(localPoint, screenPoint, operation, keyModifiers);
        }

        private void handleDragExited(DragEvent event) {
            if (event.isDropCompleted()) {
                return;
            }
            DragAndDropBridge.this.widget.dragLeave();
        }

        private void handleDragDropped(DragEvent event) {
            DropData dropData = Clipboard.of(event.getDragboard()).dropData();
            Point localPoint = this.getLocalPoint(event);
            Point screenPoint = this.getScreenPoint(event);
            KeyModifiers keyModifiers = this.keyModifiers(event);
            DragAndDropBridge.this.widget.drop(dropData, localPoint, screenPoint, keyModifiers);
            event.setDropCompleted(true);
        }

        private void handleDragDone(DragEvent event) {
            DragOperation operation = TransferModes.toDragOperation(event.getTransferMode());
            Point localPoint = this.getLocalPoint(event);
            Point screenPoint = this.getScreenPoint(event);
            DragAndDropBridge.this.widget.dragEnd(localPoint, screenPoint, operation);
            DragAndDropBridge.this.context.endDragging();
        }

        private Point getScreenPoint(DragEvent event) {
            return Point.of((int)((int)event.getScreenX()), (int)((int)event.getScreenY()));
        }

        private Point getLocalPoint(DragEvent event) {
            return Point.of((int)((int)event.getX()), (int)((int)event.getY()));
        }

        private KeyModifiers keyModifiers(DragEvent event) {
            KeyModifiers.Builder builder = KeyModifiers.newBuilder();
            return switch (event.getTransferMode()) {
                default -> throw new IncompatibleClassChangeError();
                case TransferMode.MOVE -> {
                    if (Environment.isMac()) {
                        yield builder.setMetaDown(true).build();
                    }
                    yield builder.setShiftDown(true).build();
                }
                case TransferMode.COPY -> {
                    if (Environment.isMac()) {
                        yield builder.setAltDown(true).build();
                    }
                    yield builder.setControlDown(true).build();
                }
                case TransferMode.LINK -> Environment.isMac() ? builder.setAltDown(true).setMetaDown(true).build() : builder.setControlDown(true).setShiftDown(true).build();
            };
        }
    }

    private static enum State {
        ATTACHED,
        DETACHED;

    }
}

