/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.offscreen;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.ui.ToolkitKey;
import com.teamdev.jxbrowser.internal.ui.ToolkitKeyCodes;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.KeyModifiers;
import com.teamdev.jxbrowser.ui.event.KeyPressed;
import com.teamdev.jxbrowser.ui.event.KeyReleased;
import com.teamdev.jxbrowser.ui.event.KeyTyped;
import com.teamdev.jxbrowser.ui.internal.KeyEvents;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.InputMethods;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.Key;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.KeyCodes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javafx.event.EventType;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

final class KeyboardBridge {
    private final BrowserWidget widget;
    private final InputMethods ime;
    private final ToolkitKeyCodes<Key> keyCodes;
    private final Set<KeyCode> keyPressedMemory;
    private final Map<EventType<? extends KeyEvent>, Consumer<KeyEvent>> handlers;
    private KeyCode lastKeyCode;

    private KeyboardBridge(BrowserWidget widget, InputMethods ime) {
        this.widget = widget;
        this.ime = ime;
        this.keyCodes = KeyCodes.instance();
        this.handlers = new HashMap<EventType<? extends KeyEvent>, Consumer<KeyEvent>>();
        this.handlers.put((EventType<? extends KeyEvent>)KeyEvent.KEY_PRESSED, this::dispatchKeyPressed);
        this.handlers.put((EventType<? extends KeyEvent>)KeyEvent.KEY_RELEASED, this::dispatchKeyReleased);
        this.handlers.put((EventType<? extends KeyEvent>)KeyEvent.KEY_TYPED, this::dispatchKeyTyped);
        this.keyPressedMemory = new HashSet<KeyCode>();
    }

    static KeyboardBridge newInstance(BrowserWidget widget, InputMethods ime) {
        Preconditions.checkNotNull((Object)widget);
        return new KeyboardBridge(widget, ime);
    }

    public void forward(KeyEvent event) {
        EventType eventType = event.getEventType();
        if (this.handlers.containsKey(eventType)) {
            this.handlers.get(eventType).accept(event);
        } else {
            Logger.warn((String)"Handler is not found for the event type: {0}", (Object[])new Object[]{eventType});
        }
    }

    private KeyModifiers getModifiers(KeyEvent event) {
        return KeyModifiers.newBuilder().altDown(event.isAltDown()).shiftDown(event.isShiftDown()).controlDown(event.isControlDown()).metaDown(event.isMetaDown()).build();
    }

    private void dispatchKeyPressed(KeyEvent event) {
        this.keyPressedMemory.add(event.getCode());
        com.teamdev.jxbrowser.ui.KeyCode keyCode = this.keyCodes.toKeyCode((ToolkitKey)Key.from(event));
        KeyPressed keyPressed = KeyPressed.newBuilder((com.teamdev.jxbrowser.ui.KeyCode)keyCode).keyModifiers(this.getModifiers(event)).build();
        this.widget.dispatch(keyPressed);
        this.lastKeyCode = event.getCode();
        if (this.shouldDispatchKeyTyped(event)) {
            this.dispatchKeyTyped(event);
        }
    }

    private char characterOrZero(String character) {
        return !character.isEmpty() ? character.charAt(0) : (char)'\u0000';
    }

    private void dispatchKeyReleased(KeyEvent event) {
        if (this.wasNotPressed(event.getCode())) {
            return;
        }
        this.keyPressedMemory.remove(event.getCode());
        KeyReleased keyReleased = KeyReleased.newBuilder((com.teamdev.jxbrowser.ui.KeyCode)this.keyCodes.toKeyCode((ToolkitKey)Key.from(event))).keyModifiers(this.getModifiers(event)).build();
        this.lastKeyCode = null;
        this.widget.dispatch(keyReleased);
    }

    private void dispatchKeyTyped(KeyEvent event) {
        if (this.wasNotPressed(this.lastKeyCode) || this.ime.isComposingImeText()) {
            return;
        }
        Key key = Key.of(this.lastKeyCode != null ? this.lastKeyCode : event.getCode());
        com.teamdev.jxbrowser.ui.KeyCode keyCode = this.keyCodes.toKeyCode((ToolkitKey)key);
        String character = event.getCharacter();
        char keyChar = this.characterOrZero(character);
        KeyModifiers modifiers = this.getModifiers(event);
        if (Environment.isMac() && KeyEvents.isMacAccessKey((com.teamdev.jxbrowser.ui.KeyCode)keyCode, (KeyModifiers)modifiers)) {
            keyChar = com.teamdev.jxbrowser.ui.internal.KeyCodes.toAlphabeticChar((com.teamdev.jxbrowser.ui.KeyCode)keyCode);
        }
        KeyTyped keyTyped = KeyTyped.newBuilder((com.teamdev.jxbrowser.ui.KeyCode)keyCode).keyChar(keyChar).keyModifiers(modifiers).build();
        this.widget.dispatch(keyTyped);
    }

    private boolean wasNotPressed(KeyCode lastKeyCode) {
        return !this.keyPressedMemory.contains(lastKeyCode);
    }

    private boolean shouldDispatchKeyTyped(KeyEvent event) {
        Preconditions.checkArgument((boolean)event.getEventType().equals(KeyEvent.KEY_PRESSED));
        com.teamdev.jxbrowser.ui.KeyCode keyCode = this.keyCodes.toKeyCode((ToolkitKey)Key.from(event));
        return Environment.isLinux() && keyCode == com.teamdev.jxbrowser.ui.KeyCode.KEY_CODE_RETURN && event.getText().isEmpty();
    }
}

