/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import com.teamdev.jxbrowser.browser.internal.WebDialog;
import com.teamdev.jxbrowser.browser.internal.callback.PaintWebDialogCallback;
import com.teamdev.jxbrowser.browser.internal.callback.WebDialogCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.PaintDialog;
import com.teamdev.jxbrowser.browser.internal.rpc.PaintRequest;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.ui.internal.rpc.Rect;
import com.teamdev.jxbrowser.view.swing.internal.MemoryImage;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

final class Graphics2dWebDialogView
extends JComponent {
    private final WebDialog webDialog;
    private final MemoryImage memoryImage;

    Graphics2dWebDialogView(WebDialog dialog) {
        Preconditions.checkNotNull((Object)dialog);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.webDialog = dialog;
        this.memoryImage = new MemoryImage();
        this.registerCallbacks();
    }

    private void registerCallbacks() {
        this.webDialog.set(PaintWebDialogCallback.class, (WebDialogCallback)((PaintWebDialogCallback)params -> {
            Graphics2dWebDialogView graphics2dWebDialogView = this;
            synchronized (graphics2dWebDialogView) {
                PaintRequest request = params.getPaintRequest();
                com.teamdev.jxbrowser.ui.internal.rpc.Size viewSize = request.getViewSize();
                Rect dirtyRect = request.getDirtyRect();
                if (!Graphics2dWebDialogView.validateDirtyRect((com.teamdev.jxbrowser.ui.Rect)dirtyRect, (Size)viewSize)) {
                    return PaintDialog.Response.newBuilder().build();
                }
                this.memoryImage.updatePixels((Size)viewSize, (com.teamdev.jxbrowser.ui.Rect)dirtyRect, request.getMemoryId(), request.getScaleFactor(), rectangle -> {
                    Container parent = this.getParent();
                    if (parent != null) {
                        parent.repaint();
                    }
                });
            }
            return PaintDialog.Response.newBuilder().build();
        }));
    }

    private void unregisterCallbacks() {
        this.webDialog.remove(PaintWebDialogCallback.class);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.registerCallbacks();
    }

    @Override
    public void removeNotify() {
        this.unregisterCallbacks();
        super.removeNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        Graphics2dWebDialogView graphics2dWebDialogView = this;
        synchronized (graphics2dWebDialogView) {
            this.memoryImage.image().ifPresent(image -> g.drawImage((Image)image, 0, 0, this));
        }
        super.paintComponent(g);
    }

    private static boolean validateDirtyRect(com.teamdev.jxbrowser.ui.Rect dirtyRect, Size viewSize) {
        int viewWidth = viewSize.width();
        int viewHeight = viewSize.height();
        Point dirtyRectOrigin = dirtyRect.origin();
        Size dirtyRectSize = dirtyRect.size();
        return dirtyRectOrigin.x() <= viewWidth && dirtyRectOrigin.y() <= viewHeight && dirtyRectOrigin.x() + dirtyRectSize.width() <= viewWidth && dirtyRectOrigin.y() + dirtyRectSize.height() <= viewHeight;
    }

    void setBounds(com.teamdev.jxbrowser.ui.Rect rectInPixels) {
        this.setBounds(rectInPixels.x(), rectInPixels.y(), rectInPixels.width(), rectInPixels.height());
    }
}

