/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.internal.rpc.MemoryId;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.Size;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Optional;
import java.util.function.Consumer;

final class MemoryImage {
    private int width;
    private int height;
    private BufferedImage image;
    private double deviceScaleFactor = 1.0;

    MemoryImage() {
        this.initialize(Size.of((int)1, (int)1));
    }

    public Optional<Image> image() {
        return Optional.ofNullable(this.image);
    }

    double deviceScaleFactor() {
        return this.deviceScaleFactor;
    }

    private void initialize(Size clientSize) {
        if (this.width != clientSize.width() || this.height != clientSize.height() || this.image == null) {
            this.width = clientSize.width();
            this.height = clientSize.height();
            GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice device = environment.getDefaultScreenDevice();
            GraphicsConfiguration config = device.getDefaultConfiguration();
            this.image = config.createCompatibleImage(this.width, this.height, 3);
        }
    }

    void updatePixels(Size viewSize, Rect dirtyRect, MemoryId memoryId, double scaleFactor, Consumer<Rectangle> repaintCallback) {
        Preconditions.checkNotNull(repaintCallback);
        this.deviceScaleFactor = scaleFactor;
        this.initialize(viewSize);
        if (this.image != null) {
            DataBufferInt dataBuffer = (DataBufferInt)this.image.getRaster().getDataBuffer();
            int[] data = dataBuffer.getData();
            ToolkitLibrary.instance().updatePixelInts(memoryId.getValue(), dirtyRect, viewSize, data);
            repaintCallback.accept(null);
        }
    }

    void reset() {
        this.image = null;
    }
}

