/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.internal.Preconditions;
import java.awt.datatransfer.DataFlavor;

final class MimeType {
    private final String primaryType;
    private final String subType;

    static MimeType newInstance(String mimeType) {
        String[] chunks = mimeType.split("/");
        Preconditions.checkArgument((chunks.length == 2 ? 1 : 0) != 0);
        return new MimeType(chunks[0], chunks[1]);
    }

    private MimeType(String primaryType, String subType) {
        Preconditions.checkNotNull((Object)primaryType);
        Preconditions.checkNotNull((Object)subType);
        this.primaryType = primaryType;
        this.subType = subType;
    }

    boolean matches(DataFlavor flavor) {
        boolean samePrimaryType = this.primaryType.equals(flavor.getPrimaryType());
        boolean sameSubType = this.subType.equals(flavor.getSubType());
        return samePrimaryType && sameSubType;
    }
}

