/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.menu;

import com.teamdev.jxbrowser.browser.callback.ShowContextMenuCallback;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.internal.rpc.stream.Interceptor;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.event.internal.rpc.MoveMouseWheel;
import com.teamdev.jxbrowser.view.swing.BrowserView;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

abstract class ContextMenu {
    private final BrowserView parent;
    private final BrowserImpl browser;
    private final ShowContextMenuCallback.Params params;
    private final ShowContextMenuCallback.Action callback;

    ContextMenu(BrowserView parent, ShowContextMenuCallback.Params params, ShowContextMenuCallback.Action callback) {
        this.parent = parent;
        this.browser = (BrowserImpl)parent.getBrowser();
        this.params = params;
        this.callback = callback;
    }

    ShowContextMenuCallback.Params params() {
        return this.params;
    }

    ShowContextMenuCallback.Action callback() {
        return this.callback;
    }

    protected abstract void initialize(JPopupMenu var1);

    public final void show() {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setLightWeightPopupEnabled(false);
        popupMenu.addPopupMenuListener(new PopupMenuListenerImpl());
        this.initialize(popupMenu);
        this.registerMouseCallbackInterceptors(popupMenu);
        Point location = this.params.location();
        int x = location.x();
        int y = location.y();
        SwingUtilities.invokeLater(() -> popupMenu.show(this.parent, x, y));
    }

    private void notifyContextMenuClosed() {
        this.unregisterMouseCallbackInterceptors();
        if (!this.callback.isClosed()) {
            this.callback.close();
        }
    }

    private void registerMouseCallbackInterceptors(JPopupMenu popupMenu) {
        if (this.isHardwareAccelerated()) {
            this.browser.setCallbackInterceptor(MoveMouseWheel.Request.class, params -> {
                this.hide(popupMenu);
                return Interceptor.Action.PROCEED;
            });
        }
    }

    private void unregisterMouseCallbackInterceptors() {
        if (this.isHardwareAccelerated()) {
            this.browser.setCallbackInterceptor(MoveMouseWheel.Request.class, params -> Interceptor.Action.PROCEED);
        }
    }

    private void hide(JPopupMenu popupMenu) {
        SwingUtilities.invokeLater(() -> {
            if (popupMenu.isShowing()) {
                popupMenu.setVisible(false);
            }
        });
    }

    private boolean isHardwareAccelerated() {
        return this.browser.renderingMode() == RenderingMode.HARDWARE_ACCELERATED;
    }

    private class PopupMenuListenerImpl
    implements PopupMenuListener {
        private PopupMenuListenerImpl() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            SwingUtilities.invokeLater(ContextMenu.this::notifyContextMenuClosed);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }
}

