/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser;

import com.teamdev.jxbrowser.internal.Lazy;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;

public final class ObjectClosedException
extends IllegalStateException {
    private static final String TITLE = "Attempted to use a closed object.";
    private static final Lazy<String> MESSAGE = new Lazy<String>(ObjectClosedException::message);

    public ObjectClosedException() {
        super(ObjectClosedException.fullMessage());
    }

    private static String fullMessage() {
        String emptyLine = "";
        List<String> messageLines = List.of(TITLE, emptyLine, MESSAGE.get(), emptyLine);
        return String.join((CharSequence)System.lineSeparator(), messageLines);
    }

    private static String message() {
        String string;
        block8: {
            URL message = ObjectClosedException.class.getResource("object-closed-exception-detail.txt");
            Preconditions.checkNotNull(message);
            InputStream is = message.openStream();
            try {
                byte[] rawMessage = is.readAllBytes();
                string = new String(rawMessage, StandardCharsets.UTF_8);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logger.debug("Couldn't read the exception detail file.", e);
                    return "";
                }
            }
            is.close();
        }
        return string;
    }
}

