/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.callback;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.BrowserAsyncCallback;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.callback.AsyncCallbackAction;
import com.teamdev.jxbrowser.capture.AudioCaptureMode;
import com.teamdev.jxbrowser.capture.CaptureSources;
import com.teamdev.jxbrowser.capture.NotificationVisibility;
import com.teamdev.jxbrowser.capture.internal.rpc.CaptureSource;
import com.teamdev.jxbrowser.capture.internal.rpc.SelectedCaptureSource;
import com.teamdev.jxbrowser.capture.internal.rpc.StartCaptureSession;
import com.teamdev.jxbrowser.frame.Frame;
import com.teamdev.jxbrowser.frame.internal.FrameImpl;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import java.util.function.Consumer;

public interface StartCaptureSessionCallback
extends BrowserAsyncCallback<Params, Action> {

    public static final class Action
    extends AsyncCallbackAction<StartCaptureSession.Response> {
        public Action(Consumer<StartCaptureSession.Response> consumer) {
            super(consumer);
        }

        public void selectSource(com.teamdev.jxbrowser.capture.CaptureSource source, AudioCaptureMode audioCaptureMode) {
            this.selectSource(source, audioCaptureMode, NotificationVisibility.SHOW);
        }

        public void selectSource(com.teamdev.jxbrowser.capture.CaptureSource source, AudioCaptureMode audioCaptureMode, NotificationVisibility notificationVisibility) {
            SelectedCaptureSource.Builder selectedSource = SelectedCaptureSource.newBuilder().setSource((CaptureSource)source).setCaptureAudio(audioCaptureMode == AudioCaptureMode.CAPTURE).setHideNotification(notificationVisibility == NotificationVisibility.HIDE);
            this.send(StartCaptureSession.Response.newBuilder().setSelectSource(selectedSource.build()).build());
        }

        public void selectSource(Browser browser, AudioCaptureMode audioCaptureMode) {
            this.selectSource(browser, audioCaptureMode, NotificationVisibility.SHOW);
        }

        public void selectSource(Browser browser, AudioCaptureMode audioCaptureMode, NotificationVisibility notificationVisibility) {
            StartCaptureSession.Response selectedSource = StartCaptureSession.Response.newBuilder().setSelectSource(SelectedCaptureSource.newBuilder().setBrowserId(((BrowserImpl)browser).id()).setCaptureAudio(audioCaptureMode == AudioCaptureMode.CAPTURE).setHideNotification(notificationVisibility == NotificationVisibility.HIDE)).build();
            this.send(selectedSource);
        }

        public void cancel() {
            this.send(StartCaptureSession.Response.newBuilder().setCancel(Protobuf.empty()).build());
        }

        public void showSelectSourceDialog() {
            this.send(StartCaptureSession.Response.newBuilder().setShowSelectSourceDialog(Protobuf.empty()).build());
        }
    }

    public static interface Params {
        default public boolean audioCaptureRequested() {
            return ((StartCaptureSession.Request)this).getAudioRequested();
        }

        default public Frame frame() {
            return FrameImpl.of(((StartCaptureSession.Request)this).getFrameId());
        }

        default public String url() {
            return ((StartCaptureSession.Request)this).getUrl();
        }

        default public CaptureSources sources() {
            return ((StartCaptureSession.Request)this).getCaptureSources();
        }
    }
}

